/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePackLayout;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.actions.ProvisioningConfigManipulator;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.licenses.License;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.model.FeaturePackTemplate;
import org.wildfly.prospero.model.FeaturePackTemplateManager;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class FeaturesAddAction {
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final InstallationMetadata metadata;
    private final ProsperoConfig prosperoConfig;
    private final Console console;
    private final CandidateActionsFactory candidateActionsFactory;
    private final FeaturePackTemplateManager featurePackTemplateManager;
    private LicenseManager licenseManager;

    public FeaturesAddAction(MavenOptions mavenOptions, Path installDir, List<Repository> repositories, Console console) throws MetadataException, ProvisioningException {
        this(mavenOptions, installDir, repositories, console, new DefaultCandidateActionsFactory(installDir), new FeaturePackTemplateManager());
    }

    FeaturesAddAction(MavenOptions mavenOptions, Path installDir, List<Repository> repositories, Console console, CandidateActionsFactory candidateActionsFactory, FeaturePackTemplateManager featurePackTemplateManager) throws MetadataException, ProvisioningException {
        this.installDir = installDir;
        this.console = console;
        this.metadata = InstallationMetadata.loadInstallation(installDir);
        this.prosperoConfig = this.addTemporaryRepositories(repositories);
        MavenOptions mergedOptions = this.prosperoConfig.getMavenOptions().merge(mavenOptions);
        this.mavenSessionManager = new MavenSessionManager(mergedOptions);
        this.candidateActionsFactory = candidateActionsFactory;
        this.featurePackTemplateManager = featurePackTemplateManager;
        this.licenseManager = new LicenseManager();
    }

    public void addFeaturePack(String featurePackCoord, Set<ConfigId> defaultConfigNames, Path candidatePath) throws ProvisioningException, OperationException {
        FeaturesAddAction.verifyFeaturePackCoord(featurePackCoord);
        Objects.requireNonNull(defaultConfigNames);
        FeaturePackLocation fpl = FeaturePackLocationParser.resolveFpl(featurePackCoord);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Adding feature pack " + fpl);
        }
        Map<String, Set<String>> allLayers = this.getAllLayers(fpl);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Found layers");
            for (String string : allLayers.keySet()) {
                ProsperoLogger.ROOT_LOGGER.trace(string + ": " + StringUtils.join((Object[])new Set[]{allLayers.get(string)}));
            }
        }
        HashSet<ConfigId> selectedConfigs = new HashSet<ConfigId>();
        Iterator<ConfigId> iterator = defaultConfigNames.iterator();
        while (iterator.hasNext()) {
            ConfigId defaultConfigName;
            String selectedModel = FeaturesAddAction.getSelectedModel((defaultConfigName = iterator.next()) == null ? null : defaultConfigName.getModel(), allLayers);
            String selectedConfig = FeaturesAddAction.getSelectedConfig(defaultConfigName, selectedModel);
            if (selectedConfig == null) continue;
            selectedConfigs.add(new ConfigId(selectedModel, selectedConfig));
        }
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.addingFeaturePack(fpl, StringUtils.join(selectedConfigs, (String)","), "");
        }
        GalleonProvisioningConfig galleonProvisioningConfig = this.buildProvisioningConfig(Collections.emptySet(), fpl, selectedConfigs);
        this.install(featurePackCoord, galleonProvisioningConfig, candidatePath);
    }

    public void addFeaturePackWithLayers(String featurePackCoord, Set<String> layers, ConfigId configName, Path candidateFolder) throws ProvisioningException, OperationException {
        Objects.requireNonNull(layers);
        if (layers.isEmpty() && configName != null) {
            throw new IllegalArgumentException("The layers have to be selected if configName is not empty");
        }
        FeaturesAddAction.verifyFeaturePackCoord(featurePackCoord);
        FeaturePackLocation fpl = FeaturePackLocationParser.resolveFpl(featurePackCoord);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Adding feature pack " + fpl);
        }
        Map<String, Set<String>> allLayers = this.getAllLayers(fpl);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Found layers");
            for (String key : allLayers.keySet()) {
                ProsperoLogger.ROOT_LOGGER.trace(key + ": " + StringUtils.join((Object[])new Set[]{allLayers.get(key)}));
            }
        }
        String selectedModel = FeaturesAddAction.getSelectedModel(configName == null ? null : configName.getModel(), allLayers);
        FeaturesAddAction.verifyLayerAvailable(layers, selectedModel, allLayers);
        String selectedConfig = FeaturesAddAction.getSelectedConfig(configName, selectedModel);
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.addingFeaturePack(fpl, selectedConfig + ":" + selectedModel, StringUtils.join((Object[])new Set[]{layers}));
        }
        GalleonProvisioningConfig newConfig = this.buildProvisioningConfig(layers, fpl, selectedConfig == null ? Collections.emptySet() : Set.of(new ConfigId(selectedModel, selectedConfig)));
        this.install(featurePackCoord, newConfig, candidateFolder);
    }

    public FeaturePackTemplate getFeaturePackRecipe(String featurePackCoord) throws ProvisioningException, OperationException {
        Path tempDirectory = null;
        GalleonEnvironment galleonEnv = null;
        try {
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debug("Looking up version of " + featurePackCoord);
            }
            tempDirectory = Files.createTempDirectory("prospero-temp-target", new FileAttribute[0]);
            galleonEnv = this.getGalleonEnv(tempDirectory);
            ArtifactCoordinate coord = FeaturesAddAction.toMavenCoordinates(featurePackCoord);
            String version = galleonEnv.getChannelSession().findLatestMavenArtifactVersion(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), coord.getVersion()).getVersion();
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debugf("Found version %s of %s, matching template", version, featurePackCoord);
            }
            FeaturePackTemplate featurePackTemplate = this.featurePackTemplateManager.find(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
            return featurePackTemplate;
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (galleonEnv != null) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug("Closing galleon env");
                }
                galleonEnv.close();
            }
            if (tempDirectory != null) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debugf("Removing temporary folder: %s", tempDirectory);
                }
                FileUtils.deleteQuietly((File)tempDirectory.toFile());
            }
        }
    }

    public boolean isFeaturePackAvailable(String featurePackCoord) throws OperationException, ProvisioningException {
        ArtifactCoordinate coord = FeaturesAddAction.toMavenCoordinates(featurePackCoord);
        ChannelSession channelSession = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager, false).build().getChannelSession();
        try {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Resolving a feature pack: " + featurePackCoord);
            }
            channelSession.resolveMavenArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), coord.getVersion());
        }
        catch (NoStreamFoundException e) {
            return false;
        }
        catch (ArtifactTransferException e) {
            throw new ArtifactResolutionException("Unable to resolve feature pack " + featurePackCoord, e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), false);
        }
        return true;
    }

    private static String getSelectedConfig(ConfigId defaultConfigName, String selectedModel) {
        if (defaultConfigName == null || defaultConfigName.getName() == null) {
            if (selectedModel == null) {
                return null;
            }
            return selectedModel + ".xml";
        }
        return defaultConfigName.getName();
    }

    private static void verifyFeaturePackCoord(String featurePackCoord) {
        if (featurePackCoord == null || featurePackCoord.isEmpty()) {
            throw new IllegalArgumentException("The feature pack coordinate cannot be null");
        }
        if (featurePackCoord.split(":").length != 2) {
            throw new IllegalArgumentException("The feature pack coordinate has to consist of <groupId>:<artifactId>");
        }
    }

    private void install(String featurePackCoord, GalleonProvisioningConfig newConfig, Path candidate) throws ProvisioningException, OperationException {
        List<License> pendingLicenses = this.getRequiredLicenses(featurePackCoord);
        this.verifyConfigurationsAvailable(newConfig);
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installDir);){
            metadata.updateProvisioningConfiguration();
        }
        try (PrepareCandidateAction prepareCandidateAction = this.candidateActionsFactory.newPrepareCandidateActionInstance(this.mavenSessionManager, this.prosperoConfig);
             GalleonEnvironment galleonEnv = this.getGalleonEnv(candidate);){
            ProsperoLogger.ROOT_LOGGER.updateCandidateStarted(this.installDir);
            prepareCandidateAction.buildCandidate(candidate, galleonEnv, ApplyCandidateAction.Type.FEATURE_ADD, newConfig);
            ProsperoLogger.ROOT_LOGGER.updateCandidateCompleted(this.installDir);
        }
        if (!pendingLicenses.isEmpty()) {
            try {
                this.licenseManager.recordAgreements(pendingLicenses, candidate);
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(candidate.resolve("licenses"), e);
            }
        }
    }

    private static ArtifactCoordinate toMavenCoordinates(String featurePackCoord) {
        String[] splitCoordinates;
        if (featurePackCoord == null || featurePackCoord.isEmpty()) {
            throw new IllegalArgumentException("The feature pack coordinate cannot be null");
        }
        if (featurePackCoord.endsWith("::zip")) {
            featurePackCoord = featurePackCoord.substring(0, featurePackCoord.length() - "::zip".length());
        }
        if ((splitCoordinates = featurePackCoord.split(":")).length != 2) {
            throw new IllegalArgumentException("The feature pack coordinate has to consist of <groupId>:<artifactId>");
        }
        ArtifactCoordinate coord = new ArtifactCoordinate(splitCoordinates[0], splitCoordinates[1], "zip", null, "");
        return coord;
    }

    private GalleonProvisioningConfig buildProvisioningConfig(Set<String> layers, FeaturePackLocation fpl, Set<ConfigId> selectedConfigs) throws ProvisioningException, OperationException {
        if (!layers.isEmpty() && selectedConfigs.size() > 1) {
            throw new IllegalArgumentException("Only one config can be selected when selecting layers");
        }
        try (GalleonEnvironment galleonEnv = this.getGalleonEnv(this.installDir);){
            GalleonProvisioningConfig galleonProvisioningConfig;
            block19: {
                Provisioning pm = galleonEnv.getProvisioning();
                try {
                    FeaturePackTemplate mapping;
                    int fpIndex;
                    GalleonProvisioningConfig newConfig;
                    GalleonProvisioningConfig existingConfig = pm.getProvisioningConfig();
                    GalleonProvisioningConfig.Builder builder = GalleonProvisioningConfig.builder((GalleonProvisioningConfig)existingConfig);
                    GalleonFeaturePackConfig.Builder fpBuilder = FeaturesAddAction.buildFeaturePackConfig(fpl, existingConfig, builder);
                    if (!selectedConfigs.isEmpty()) {
                        fpBuilder.setInheritConfigs(false);
                    }
                    for (ConfigId selectedConfig : selectedConfigs) {
                        if (selectedConfig == null) continue;
                        fpBuilder.setInheritConfigs(false);
                        if (!layers.isEmpty()) {
                            GalleonConfigurationWithLayersBuilderItf configBuilder = FeaturesAddAction.buildLayerConfig(layers, selectedConfig.getName(), selectedConfig.getModel(), pm, existingConfig, builder);
                            builder.addConfig(configBuilder.build());
                            continue;
                        }
                        fpBuilder.includeDefaultConfig(selectedConfig.getModel(), selectedConfig.getName());
                    }
                    if (!layers.isEmpty()) {
                        fpBuilder.setInheritPackages(false);
                    }
                    if ((newConfig = ((GalleonProvisioningConfig.Builder)builder.addFeaturePackDep(fpIndex = (mapping = this.getFeaturePackRecipe(fpl.getProducerName())) != null ? FeaturesAddAction.applyProvisioningTemplate(fpl, builder, mapping, existingConfig, fpBuilder) : existingConfig.getFeaturePackDeps().size(), fpBuilder.build())).build()).equals((Object)existingConfig)) {
                        throw ProsperoLogger.ROOT_LOGGER.featurePackAlreadyInstalled(fpl);
                    }
                    if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.trace("New provisioning configuration: " + newConfig);
                    }
                    galleonProvisioningConfig = newConfig;
                    if (pm == null) break block19;
                }
                catch (Throwable throwable) {
                    if (pm != null) {
                        try {
                            pm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pm.close();
            }
            return galleonProvisioningConfig;
        }
    }

    private static int applyProvisioningTemplate(FeaturePackLocation fpl, GalleonProvisioningConfig.Builder builder, FeaturePackTemplate mapping, GalleonProvisioningConfig existingConfig, GalleonFeaturePackConfig.Builder fpBuilder) throws ProvisioningException {
        ProvisioningConfigManipulator provisioningConfigManipulator = new ProvisioningConfigManipulator(builder);
        int fpIndex = -1;
        if (mapping.getReplacesDependency() != null) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Replacing %s dependency with %s", mapping.getReplacesDependency(), fpl);
            }
            fpIndex = provisioningConfigManipulator.removeFeaturePackDefinition(mapping.getReplacesDependency());
            GalleonFeaturePackConfig removedConfig = existingConfig.getFeaturePackDep(FeaturePackLocationParser.resolveFpl(mapping.getReplacesDependency()).getProducer());
            ProvisioningConfigManipulator.copyFeaturePackConfig(removedConfig, fpBuilder);
        } else if (mapping.getTransitiveDependency() != null) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Marking %s as a transitive dependency", mapping.getTransitiveDependency());
            }
            fpIndex = provisioningConfigManipulator.convertToTransitiveDep(mapping.getTransitiveDependency(), existingConfig);
        } else {
            fpIndex = existingConfig.getFeaturePackDeps().size();
        }
        for (String additionalPackage : mapping.getAdditionalPackages()) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Adding additional package %s to %s", additionalPackage, fpl);
            }
            if (fpBuilder.isPackageExcluded(additionalPackage)) continue;
            fpBuilder.includePackage(additionalPackage);
        }
        return fpIndex;
    }

    private static GalleonFeaturePackConfig.Builder buildFeaturePackConfig(FeaturePackLocation fpl, GalleonProvisioningConfig existingConfig, GalleonProvisioningConfig.Builder builder) throws ProvisioningException {
        GalleonFeaturePackConfig.Builder fpBuilder;
        if (existingConfig.hasFeaturePackDep(fpl.getProducer())) {
            GalleonFeaturePackConfig fp = existingConfig.getFeaturePackDep(fpl.getProducer());
            fpBuilder = GalleonFeaturePackConfig.builder((GalleonFeaturePackConfig)fp);
            builder.removeFeaturePackDep(fp.getLocation());
        } else {
            fpBuilder = GalleonFeaturePackConfig.builder((FeaturePackLocation)fpl);
        }
        return fpBuilder;
    }

    private static GalleonConfigurationWithLayersBuilderItf buildLayerConfig(Set<String> layers, String selectedConfig, String selectedModel, Provisioning provisioning, GalleonProvisioningConfig existingConfig, GalleonProvisioningConfig.Builder builder) throws ProvisioningException {
        GalleonConfigurationWithLayersBuilder configBuilder;
        ConfigId id = new ConfigId(selectedModel, selectedConfig);
        if (existingConfig.hasDefinedConfig(id)) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Replacing existing ConfigModel " + id);
            }
            GalleonConfigurationWithLayers cmodel = existingConfig.getDefinedConfig(id);
            configBuilder = provisioning.buildConfigurationBuilder(cmodel);
            FeaturesAddAction.includeLayers(layers, (GalleonConfigurationWithLayersBuilderItf)configBuilder, cmodel);
            builder.removeConfig(id);
        } else {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Adding new ConfigModel " + id);
            }
            configBuilder = GalleonConfigurationWithLayersBuilder.builder((String)selectedModel, (String)selectedConfig);
            for (String layer : layers) {
                configBuilder.includeLayer(layer);
            }
        }
        return configBuilder;
    }

    private static void includeLayers(Set<String> layers, GalleonConfigurationWithLayersBuilderItf configBuilder, GalleonConfigurationWithLayers cmodel) throws ProvisioningDescriptionException {
        for (String layer : layers) {
            if (cmodel.getExcludedLayers().contains(layer)) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Un-excluding layer" + layer);
                }
                configBuilder.removeExcludedLayer(layer);
            }
            if (cmodel.getIncludedLayers().contains(layer)) continue;
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Adding layer " + layer);
            }
            configBuilder.includeLayer(layer);
        }
    }

    private static void verifyLayerAvailable(Set<String> layers, String selectedModel, Map<String, Set<String>> allLayers) throws LayerNotFoundException {
        if (allLayers.isEmpty() && !layers.isEmpty()) {
            String missingLayers = StringUtils.join(layers, (String)", ");
            throw new LayerNotFoundException(ProsperoLogger.ROOT_LOGGER.layerNotFoundInFeaturePack(missingLayers), layers, Collections.emptySet());
        }
        if (selectedModel != null) {
            Set<String> modelLayers = allLayers.get(selectedModel);
            for (String layer : layers) {
                Set<String> missingLayers = layers.stream().filter(l -> !modelLayers.contains(layer)).collect(Collectors.toSet());
                if (missingLayers.isEmpty()) continue;
                String missingLayersTxt = StringUtils.join(missingLayers, (String)", ");
                throw new LayerNotFoundException(ProsperoLogger.ROOT_LOGGER.layerNotFoundInFeaturePack(missingLayersTxt), missingLayers, modelLayers);
            }
        }
    }

    private void verifyConfigurationsAvailable(GalleonProvisioningConfig config) throws ProvisioningException, OperationException {
        try (GalleonEnvironment env = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager, false).build();){
            Stream<ConfigId> configIds = Stream.concat(config.getFeaturePackDeps().stream().flatMap(fd -> fd.getIncludedConfigs().stream()), config.getDefinedConfigs().stream().map(GalleonConfigurationWithLayers::getId));
            Optional<ConfigId> missingConfig = configIds.filter(cfg -> {
                try {
                    return !env.getProvisioning().hasOrderedFeaturePacksConfig(config, cfg);
                }
                catch (ProvisioningException ex) {
                    throw new RuntimeException(ex);
                }
            }).findFirst();
            if (missingConfig.isPresent()) {
                ConfigId cfg2 = missingConfig.get();
                throw new ConfigurationNotFoundException(ProsperoLogger.ROOT_LOGGER.galleonConfigNotFound(cfg2.getModel(), cfg2.getName()), cfg2);
            }
        }
    }

    public List<License> getRequiredLicenses(String featurePackCoord) {
        return this.licenseManager.getLicenses(Set.of(featurePackCoord));
    }

    private static String getSelectedModel(String model, Map<String, Set<String>> allLayers) throws ModelNotDefinedException {
        String selectedModel;
        if (allLayers.isEmpty()) {
            return null;
        }
        if (model == null || model.isEmpty()) {
            if (allLayers.size() > 1) {
                throw new ModelNotDefinedException(ProsperoLogger.ROOT_LOGGER.noDefaultModel(), allLayers.keySet());
            }
            selectedModel = allLayers.keySet().iterator().next();
        } else {
            if (!allLayers.containsKey(model)) {
                throw new ModelNotDefinedException(ProsperoLogger.ROOT_LOGGER.modelNotFoundInFeaturePack(model), model, allLayers.keySet());
            }
            selectedModel = model;
        }
        return selectedModel;
    }

    private GalleonEnvironment getGalleonEnv(Path target) throws ProvisioningException, OperationException {
        return GalleonEnvironment.builder(target, this.prosperoConfig.getChannels(), this.mavenSessionManager, false).setSourceServerPath(this.installDir).setConsole(this.console).build();
    }

    private Map<String, Set<String>> getAllLayers(FeaturePackLocation fpl) throws ProvisioningException, OperationException {
        GalleonProvisioningConfig config = ((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(GalleonFeaturePackConfig.builder((FeaturePackLocation)fpl).build())).build();
        MavenRepoManager repositoryManager = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager, false).build().getRepositoryManager();
        HashMap<String, Set<String>> layersMap = new HashMap<String, Set<String>>();
        try (Provisioning p = ((GalleonBuilder)new GalleonBuilder().addArtifactResolver((RepositoryArtifactResolver)repositoryManager)).newProvisioningBuilder(config).build();
             GalleonProvisioningLayout layout = p.newProvisioningLayout(config);){
            for (GalleonFeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                Set configIds;
                try {
                    configIds = fp.loadLayers();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (ConfigId layer : configIds) {
                    String model = layer.getModel();
                    HashSet<String> names = (HashSet<String>)layersMap.get(model);
                    if (names == null) {
                        names = new HashSet<String>();
                        layersMap.put(model, names);
                    }
                    names.add(layer.getName());
                }
            }
        }
        return layersMap;
    }

    private ProsperoConfig addTemporaryRepositories(List<Repository> repositories) {
        ProsperoConfig prosperoConfig = this.metadata.getProsperoConfig();
        List<Channel> channels = TemporaryRepositoriesHandler.overrideRepositories(prosperoConfig.getChannels(), repositories);
        return new ProsperoConfig(channels, prosperoConfig.getMavenOptions());
    }

    private static class DefaultCandidateActionsFactory
    implements CandidateActionsFactory {
        private final Path installDir;

        public DefaultCandidateActionsFactory(Path installDir) {
            this.installDir = installDir;
        }

        @Override
        public PrepareCandidateAction newPrepareCandidateActionInstance(MavenSessionManager mavenSessionManager, ProsperoConfig prosperoConfig) throws OperationException {
            return new PrepareCandidateAction(this.installDir, mavenSessionManager, prosperoConfig);
        }

        @Override
        public ApplyCandidateAction newApplyCandidateActionInstance(Path candidateDir) throws ProvisioningException, OperationException {
            return new ApplyCandidateAction(this.installDir, candidateDir);
        }
    }

    static interface CandidateActionsFactory {
        public PrepareCandidateAction newPrepareCandidateActionInstance(MavenSessionManager var1, ProsperoConfig var2) throws OperationException;

        public ApplyCandidateAction newApplyCandidateActionInstance(Path var1) throws ProvisioningException, OperationException;
    }

    public static class ConfigurationNotFoundException
    extends OperationException {
        private final String model;
        private final String name;

        public ConfigurationNotFoundException(String msg, ConfigId id) {
            super(msg);
            this.model = id.getModel();
            this.name = id.getName();
        }

        public String getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class FeaturePackAlreadyInstalledException
    extends OperationException {
        public FeaturePackAlreadyInstalledException(String msg) {
            super(msg);
        }
    }

    public static class ModelNotDefinedException
    extends OperationException {
        private String model;
        private Set<String> supportedModels;

        public ModelNotDefinedException(String msg, Set<String> supportedModels) {
            super(msg);
            this.supportedModels = supportedModels;
        }

        public ModelNotDefinedException(String msg, String model, Set<String> supportedModels) {
            super(msg);
            this.model = model;
            this.supportedModels = supportedModels;
        }

        public String getModel() {
            return this.model;
        }

        public Set<String> getSupportedModels() {
            return new TreeSet<String>(this.supportedModels);
        }
    }

    public static class LayerNotFoundException
    extends OperationException {
        private final Set<String> layers;
        private final Set<String> supportedLayers;

        public LayerNotFoundException(String msg, Set<String> layers, Set<String> supportedLayers) {
            super(msg);
            this.layers = layers;
            this.supportedLayers = supportedLayers;
        }

        public Set<String> getLayers() {
            return this.layers;
        }

        public Set<String> getSupportedLayers() {
            return new TreeSet<String>(this.supportedLayers);
        }
    }
}

