/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.api.Diff;

public class ArtifactChange
extends Diff {
    private final String channelName;

    public static ArtifactChange added(Artifact newVersion) {
        Objects.requireNonNull(newVersion);
        return new ArtifactChange(ArtifactChange.toGav(newVersion), null, newVersion.getVersion());
    }

    public static ArtifactChange added(Artifact newVersion, String channelName) {
        Objects.requireNonNull(newVersion);
        return new ArtifactChange(ArtifactChange.toGav(newVersion), null, newVersion.getVersion(), channelName);
    }

    public static ArtifactChange removed(Artifact oldVersion) {
        Objects.requireNonNull(oldVersion);
        return new ArtifactChange(ArtifactChange.toGav(oldVersion), oldVersion.getVersion(), null);
    }

    public static ArtifactChange updated(Artifact oldVersion, Artifact newVersion) {
        Objects.requireNonNull(oldVersion);
        Objects.requireNonNull(newVersion);
        return new ArtifactChange(ArtifactChange.toGav(oldVersion), oldVersion.getVersion(), newVersion.getVersion());
    }

    public static ArtifactChange updated(Artifact oldVersion, Artifact newVersion, String channelName) {
        Objects.requireNonNull(oldVersion);
        Objects.requireNonNull(newVersion);
        return new ArtifactChange(ArtifactChange.toGav(oldVersion), oldVersion.getVersion(), newVersion.getVersion(), channelName);
    }

    private ArtifactChange(String gav, String oldVersion, String newVersion) {
        this(gav, oldVersion, newVersion, null);
    }

    private ArtifactChange(String gav, String oldVersion, String newVersion, String channelName) {
        super(gav, oldVersion, newVersion);
        this.channelName = channelName;
    }

    public String getArtifactName() {
        return this.getName().get();
    }

    public Optional<String> getOldVersion() {
        return this.getOldValue();
    }

    public Optional<String> getChannelName() {
        return Optional.ofNullable(this.channelName);
    }

    public Optional<String> getNewVersion() {
        return this.getNewValue();
    }

    private static String toGav(Artifact artifact) {
        String gac = artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? String.format("%s:%s", artifact.getGroupId(), artifact.getArtifactId()) : String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier());
        return gac;
    }

    public boolean isDowngrade() {
        if (this.getNewValue().isPresent() && this.getOldValue().isPresent()) {
            return VersionMatcher.COMPARATOR.compare(this.getNewValue().get(), this.getOldValue().get()) < 0;
        }
        return false;
    }

    public boolean isInstalled() {
        return this.getOldValue().isEmpty();
    }

    public boolean isRemoved() {
        return this.getNewValue().isEmpty();
    }

    public boolean isUpdated() {
        return this.getOldValue().isPresent() && this.getNewValue().isPresent();
    }

    public String prettyPrint() {
        return String.format("[%s] %s %s ==> %s @ %s", new Object[]{this.getStatus(), this.getName().orElse(""), this.getOldValue().orElse("[]"), this.getNewValue().orElse("[]"), this.getChannelName().orElse("Unknown")});
    }

    public ArtifactChange reverse() {
        if (this.isUpdated()) {
            return new ArtifactChange(this.getName().get(), this.getNewVersion().get(), this.getOldVersion().get(), this.channelName);
        }
        if (this.isInstalled()) {
            return new ArtifactChange(this.getArtifactName(), this.getNewVersion().get(), null, this.channelName);
        }
        return new ArtifactChange(this.getArtifactName(), null, this.getOldVersion().get(), this.channelName);
    }
}

