/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.installation.git;

import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

class NonPersistingSystemReader
extends SystemReader {
    private final SystemReader systemReader;

    public NonPersistingSystemReader(SystemReader systemReader) {
        this.systemReader = systemReader;
    }

    public String getHostname() {
        return this.systemReader.getHostname();
    }

    public String getenv(String s) {
        return this.systemReader.getenv(s);
    }

    public String getProperty(String s) {
        return this.systemReader.getProperty(s);
    }

    public StoredConfig getUserConfig() throws ConfigInvalidException, IOException {
        return new NonPersistStoredConfig();
    }

    public StoredConfig getJGitConfig() throws ConfigInvalidException, IOException {
        return new NonPersistStoredConfig();
    }

    public StoredConfig getSystemConfig() throws ConfigInvalidException, IOException {
        return new NonPersistStoredConfig();
    }

    public FileBasedConfig openUserConfig(Config config, FS fs) {
        return new EmptyFileBasedConfig(config, fs);
    }

    public FileBasedConfig openSystemConfig(Config config, FS fs) {
        return new EmptyFileBasedConfig(config, fs);
    }

    public FileBasedConfig openJGitConfig(Config config, FS fs) {
        return new EmptyFileBasedConfig(config, fs);
    }

    public long getCurrentTime() {
        return this.systemReader.getCurrentTime();
    }

    public int getTimezone(long l) {
        return this.systemReader.getTimezone(l);
    }

    private static class NonPersistStoredConfig
    extends StoredConfig {
        private NonPersistStoredConfig() {
        }

        public void load() throws IOException, ConfigInvalidException {
            this.clear();
        }

        public void save() throws IOException {
        }
    }

    private static class EmptyFileBasedConfig
    extends FileBasedConfig {
        public EmptyFileBasedConfig(Config config, FS fs) {
            super(config, null, fs);
        }

        public void load() throws IOException, ConfigInvalidException {
            this.clear();
        }

        public void save() throws IOException {
        }
    }
}

