/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.printers;

import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.api.Console;

public class ChannelPrinter {
    private final Console console;
    private final int indentSize;

    public ChannelPrinter(Console console) {
        this(console, 0);
    }

    public ChannelPrinter(Console console, int indentSize) {
        this.console = console;
        this.indentSize = indentSize;
    }

    public void print(Channel channel) {
        String startMarker = "# ";
        if (channel.getName() != null && !channel.getName().isEmpty()) {
            this.printLine(startMarker + channel.getName());
            startMarker = "  ";
        }
        String manifest = channel.getManifestCoordinate().getMaven() == null ? channel.getManifestCoordinate().getUrl().toExternalForm() : ChannelPrinter.toGav(channel.getManifestCoordinate().getMaven());
        this.printLine(startMarker + "manifest: " + manifest);
        this.printLine("  repositories:");
        for (Repository repository : channel.getRepositories()) {
            this.printLine("    id: " + repository.getId());
            this.printLine("    url: " + repository.getUrl());
        }
    }

    private void printLine(String text) {
        this.console.println(" ".repeat(this.indentSize) + text);
    }

    private static String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }
}

