/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.exceptions.ArtifactPromoteException;
import org.wildfly.prospero.promotion.ArtifactBundle;
import org.wildfly.prospero.promotion.ArtifactPromoter;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class PromoteArtifactBundleAction {
    private final Console console;

    public PromoteArtifactBundleAction(Console console) {
        this.console = console;
    }

    public void promote(Path archive, URL targetRepository, ChannelManifestCoordinate coordinate) throws ProvisioningException, ArtifactPromoteException {
        Objects.requireNonNull(archive);
        Objects.requireNonNull(targetRepository);
        Objects.requireNonNull(coordinate);
        if (coordinate.getMaven() == null) {
            throw ProsperoLogger.ROOT_LOGGER.nonMavenChannelRef();
        }
        try (ArtifactBundle extracted = ArtifactBundle.extract(archive);){
            this.console.println(ProsperoLogger.ROOT_LOGGER.promotingArtifacts(targetRepository));
            for (ArtifactCoordinate artifact : extracted.getArtifactList()) {
                this.console.println("  * " + String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            }
            MavenSessionManager msm = new MavenSessionManager(MavenOptions.OFFLINE_NO_CACHE);
            RepositorySystem system = msm.newRepositorySystem();
            DefaultRepositorySystemSession session = msm.newRepositorySystemSession(system);
            RemoteRepository sourceRepo = new RemoteRepository.Builder("source-repo", "default", extracted.getRepository().toUri().toURL().toString()).build();
            RemoteRepository targetRepo = new RemoteRepository.Builder("target-repo", "default", targetRepository.toString()).build();
            ArtifactPromoter promoter = new ArtifactPromoter(system, session, targetRepo);
            try {
                promoter.promote(extracted.getArtifactList(), new ChannelCoordinate(coordinate.getMaven().getGroupId(), coordinate.getMaven().getArtifactId()), sourceRepo);
            }
            catch (IOException | DeploymentException | ArtifactResolutionException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToPromote(targetRepository, (Exception)e);
            }
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseCustomizationBundle(archive, e);
        }
    }
}

