/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.api.Diff;

public class ChannelChange
extends Diff {
    private final Channel old;
    private final Channel current;

    public static ChannelChange added(Channel current) {
        return new ChannelChange(null, current);
    }

    public static ChannelChange modified(Channel old, Channel current) {
        return new ChannelChange(old, current);
    }

    public static ChannelChange removed(Channel old) {
        return new ChannelChange(old, null);
    }

    public Channel getOldChannel() {
        return this.old;
    }

    public Channel getNewChannel() {
        return this.current;
    }

    private ChannelChange(Channel old, Channel current) {
        super(ChannelChange.getName(old, current), ChannelChange.getStatus(old, current), ChannelChange.diffChildren(old, current));
        this.old = old;
        this.current = current;
    }

    private static List<Diff> diffChildren(Channel old, Channel current) {
        List<Diff> repositoriesDiffs;
        String currentManifest;
        ArrayList<Diff> children = new ArrayList<Diff>();
        String oldManifest = ChannelChange.getManifest(old);
        if (!StringUtils.equals((CharSequence)oldManifest, (CharSequence)(currentManifest = ChannelChange.getManifest(current)))) {
            children.add(new Diff("manifest", oldManifest, currentManifest));
        }
        if (!(repositoriesDiffs = ChannelChange.repositoriesDiffs(old, current)).isEmpty()) {
            children.add(new Diff("repositories", Diff.Status.MODIFIED, repositoriesDiffs));
        }
        return children;
    }

    private static List<Diff> repositoriesDiffs(Channel channel1, Channel channel2) {
        ArrayList<Diff> repoDiffs = new ArrayList<Diff>();
        if (channel1 != null && channel2 != null) {
            int i;
            for (i = 0; i < channel1.getRepositories().size(); ++i) {
                String r2Name;
                Repository r1 = (Repository)channel1.getRepositories().get(i);
                Repository r2 = channel2.getRepositories().size() > i ? (Repository)channel2.getRepositories().get(i) : null;
                String r1Name = r1.getId() + "::" + r1.getUrl();
                String string = r2Name = r2 == null ? null : r2.getId() + "::" + r2.getUrl();
                if (r1Name.equals(r2Name)) continue;
                repoDiffs.add(new Diff(null, r1Name, r2Name));
            }
            for (i = channel1.getRepositories().size(); i < channel2.getRepositories().size(); ++i) {
                Repository r = (Repository)channel2.getRepositories().get(i);
                repoDiffs.add(new Diff(null, null, r.getId() + "::" + r.getUrl()));
            }
        } else if (channel1 == null) {
            for (Repository r : channel2.getRepositories()) {
                repoDiffs.add(new Diff(null, null, r.getId() + "::" + r.getUrl()));
            }
        } else {
            for (Repository r : channel1.getRepositories()) {
                repoDiffs.add(new Diff(null, r.getId() + "::" + r.getUrl(), null));
            }
        }
        return repoDiffs;
    }

    private static String getName(Channel channel1, Channel channel2) {
        return channel1 != null ? channel1.getName() : channel2.getName();
    }

    private static Diff.Status getStatus(Channel old, Channel current) {
        return old == null ? Diff.Status.ADDED : (current == null ? Diff.Status.REMOVED : Diff.Status.MODIFIED);
    }

    private static String getManifest(Channel channel) {
        if (channel == null) {
            return null;
        }
        if (channel.getManifestCoordinate() == null) {
            return null;
        }
        return channel.getManifestCoordinate().getMaven() == null ? channel.getManifestCoordinate().getUrl().toExternalForm() : ChannelChange.toGav(channel.getManifestCoordinate().getMaven());
    }

    private static String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }
}

