/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.api.exceptions.InvalidRepositoryArchiveException;

public class RepositoryUtils {
    private static final Logger LOG = Logger.getLogger((String)RepositoryUtils.class.getName());

    public static Repository toChannelRepository(RemoteRepository r) {
        return new Repository(r.getId(), r.getUrl());
    }

    public static RemoteRepository toRemoteRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).setPolicy(VersionResolverFactory.DEFAULT_REPOSITORY_POLICY).build();
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        return RepositoryUtils.toRemoteRepository(repository.getId(), repository.getUrl());
    }

    public static List<Repository> unzipArchives(List<Repository> repositories, TemporaryFilesManager temporaryFiles) throws InvalidRepositoryArchiveException {
        Objects.requireNonNull(repositories);
        if (repositories.isEmpty()) {
            return repositories;
        }
        ArrayList<Repository> mappedRepositories = new ArrayList<Repository>();
        for (Repository repository : repositories) {
            try {
                String newUrl;
                Path archivePath;
                if (RepositoryUtils.isLocalZipFile(repository)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Treating " + repository.getUrl() + " as a local archive."));
                    }
                    archivePath = Path.of(URI.create(repository.getUrl()));
                    newUrl = RepositoryUtils.extractArchive(archivePath, temporaryFiles);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Extracted " + repository.getUrl() + " to " + newUrl));
                    }
                    mappedRepositories.add(new Repository(repository.getId(), newUrl));
                    continue;
                }
                if (RepositoryUtils.isRemoteZipFile(repository)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Treating " + repository.getUrl() + " as a remote archive."));
                    }
                    archivePath = temporaryFiles.createTempFile("prospero-repository", ".zip");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Downloaded " + repository.getUrl() + " to " + String.valueOf(archivePath)));
                    }
                    IOUtils.copy((URL)new URL(repository.getUrl()), (File)archivePath.toFile());
                    newUrl = RepositoryUtils.extractArchive(archivePath, temporaryFiles);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Extracted " + repository.getUrl() + " to " + newUrl));
                    }
                    mappedRepositories.add(new Repository(repository.getId(), newUrl));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Treating " + repository.getUrl() + " as a repository URL."));
                }
                mappedRepositories.add(repository);
            }
            catch (IOException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToExtractRepositoryArchive(repository.getUrl(), e);
            }
        }
        return mappedRepositories;
    }

    private static String extractArchive(Path archivePath, TemporaryFilesManager temporaryFiles) throws IOException, InvalidRepositoryArchiveException {
        Path tempRepo = temporaryFiles.createTempDirectory("prospero-repository");
        ZipUtils.unzip((Path)archivePath, (Path)tempRepo);
        Path mavenRepositoryFolder = RepositoryUtils.findRepositoryFolder(tempRepo);
        return mavenRepositoryFolder.toUri().toURL().toString();
    }

    private static Path findRepositoryFolder(Path tempRepo) throws InvalidRepositoryArchiveException {
        File[] repoChildren = tempRepo.toFile().listFiles(File::isDirectory);
        if (repoChildren == null || repoChildren.length != 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The repository archive has to contain a single root folder. " + String.valueOf(tempRepo)));
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidRepositoryArchive();
        }
        File rootFile = repoChildren[0];
        Path mavenRepositoryFolder = rootFile.toPath().resolve("maven-repository");
        if (!Files.exists(mavenRepositoryFolder, new LinkOption[0]) || !Files.isDirectory(mavenRepositoryFolder, new LinkOption[0])) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sub-folder maven-repository not found under the root of the archive " + String.valueOf(mavenRepositoryFolder.getParent())));
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidRepositoryArchive();
        }
        return mavenRepositoryFolder;
    }

    private static boolean isLocalZipFile(Repository repository) {
        try {
            URI uri = URI.create(repository.getUrl());
            if (!"file".equals(uri.getScheme()) || !repository.getUrl().endsWith(".zip")) {
                return false;
            }
            Path path = uri.isOpaque() ? Path.of(uri.toURL().getPath(), new String[0]) : Path.of(uri);
            if (!Files.exists(path, new LinkOption[0])) {
                return false;
            }
            FileSystems.newFileSystem(path, (ClassLoader)null).close();
            return true;
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(repository.getUrl() + " is not a valid zip archive, treating it as URL"), (Throwable)e);
            }
            return false;
        }
    }

    private static boolean isRemoteZipFile(Repository repository) {
        block4: {
            try {
                URLConnection connection;
                URL url = new URL(repository.getUrl());
                if (!url.getFile().endsWith(".zip")) {
                    return false;
                }
                if ((url.getProtocol().equals("http") || url.getProtocol().equals("https")) && (connection = url.openConnection()) instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).setRequestMethod("HEAD");
                    connection.connect();
                    String contentType = connection.getContentType();
                    return "application/zip".equals(contentType);
                }
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace((Object)(repository.getUrl() + " unable to determine content type, treating as repository URL"), (Throwable)e);
            }
        }
        return false;
    }
}

