/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.ProvisioningBuilder;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.logging.Logger;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.LoggingMessageWriter;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonUtils {
    public static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    protected static final String JBOSS_MODULES_SETTINGS_XML_URL = "jboss.modules.settings.xml.url";
    public static final String JBOSS_FORK_EMBEDDED_PROPERTY = "jboss-fork-embedded";
    public static final String JBOSS_FORK_EMBEDDED_VALUE = "true";
    public static final String JBOSS_BULK_RESOLVE_PROPERTY = "jboss-bulk-resolve-artifacts";
    public static final String JBOSS_BULK_RESOLVE_VALUE = "true";
    public static final String MODULE_PATH_PROPERTY = "module.path";
    public static final String PRINT_ONLY_CONFLICTS_PROPERTY = "print-only-conflicts";
    public static final String PRINT_ONLY_CONFLICTS_VALUE = "true";
    public static final String STORE_INPUT_PROVISIONING_CONFIG_PROPERTY = "store-input-provisioning-config";
    public static final String STORE_INPUT_PROVISIONING_CONFIG_VALUE = "true";
    public static final String STORE_PROVISIONED_ARTIFACTS = "jboss-resolved-artifacts-cache";
    public static final String STORE_PROVISIONED_ARTIFACTS_VALUE = ArtifactCache.CACHE_FOLDER.toString().replace(File.separatorChar, '/');
    private static final String CLASSPATH_SCHEME = "classpath";
    private static final String FILE_SCHEME = "file";
    private static final String OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES = "jboss-reset-embedded-system-properties";
    private static final Logger logger = Logger.getLogger((String)GalleonUtils.class.getName());

    public static void executeGalleon(GalleonExecution execution, Path localRepository) throws ProvisioningException, UnresolvedMavenArtifactException {
        HashMap<String, String> substitutedProperties = new HashMap<String, String>();
        try {
            substitutedProperties.putAll(GalleonUtils.substituteProvisioningProperties(localRepository));
            HashMap<String, String> options = new HashMap<String, String>();
            options.put(JBOSS_FORK_EMBEDDED_PROPERTY, "true");
            options.put(JBOSS_BULK_RESOLVE_PROPERTY, "true");
            options.put(PRINT_ONLY_CONFLICTS_PROPERTY, "true");
            options.put(STORE_INPUT_PROVISIONING_CONFIG_PROPERTY, "true");
            options.put(STORE_PROVISIONED_ARTIFACTS, STORE_PROVISIONED_ARTIFACTS_VALUE);
            String resetSysProp = System.getProperty(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES, "");
            if (!resetSysProp.equals("-")) {
                options.put(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES, resetSysProp);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Executing galleon");
                logger.trace((Object)"System properties:");
                for (Object object : System.getProperties().keySet()) {
                    logger.trace((Object)("  " + String.valueOf(object) + ": " + String.valueOf(System.getProperties().get(object))));
                }
                logger.trace((Object)"System envs:");
                for (String string : System.getenv().keySet()) {
                    logger.trace((Object)("  " + string + ": " + System.getenv().get(string)));
                }
                logger.trace((Object)"Galleon options:");
                for (String string : options.keySet()) {
                    logger.trace((Object)("  " + string + ": " + (String)options.get(string)));
                }
            }
            execution.execute(options);
        }
        catch (ProvisioningException e) {
            throw GalleonUtils.extractMavenException(e).orElseThrow(() -> e);
        }
        finally {
            try {
                Path tempSettingsXml = Path.of(new URL(System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL)).toURI());
                FileUtils.deleteQuietly((File)tempSettingsXml.toFile());
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException("Unable to delete a temporary settings.xml file " + System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL), e);
            }
            for (Map.Entry property : substitutedProperties.entrySet()) {
                if (property.getValue() == null) {
                    System.clearProperty((String)property.getKey());
                    continue;
                }
                System.setProperty((String)property.getKey(), (String)property.getValue());
            }
        }
    }

    private static Map<String, String> substituteProvisioningProperties(Path localRepository) throws ProvisioningException {
        HashMap<String, String> substitutedProperties = new HashMap<String, String>();
        substitutedProperties.put(MAVEN_REPO_LOCAL, System.getProperty(MAVEN_REPO_LOCAL));
        System.setProperty(MAVEN_REPO_LOCAL, localRepository.toString());
        if (System.getProperty(MODULE_PATH_PROPERTY) != null) {
            substitutedProperties.put(MODULE_PATH_PROPERTY, System.getProperty(MODULE_PATH_PROPERTY));
            System.clearProperty(MODULE_PATH_PROPERTY);
        }
        if (System.getProperty("logging.configuration") != null) {
            substitutedProperties.put("logging.configuration", System.getProperty("logging.configuration"));
            System.clearProperty("logging.configuration");
        }
        try {
            substitutedProperties.put(JBOSS_MODULES_SETTINGS_XML_URL, System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL));
            Path tempSettingsXml = Files.createTempFile("prospero-maven-settings", "xml", new FileAttribute[0]);
            Files.writeString(tempSettingsXml, (CharSequence)"<settings/>", new OpenOption[0]);
            System.setProperty(JBOSS_MODULES_SETTINGS_XML_URL, tempSettingsXml.toUri().toURL().toExternalForm());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        return substitutedProperties;
    }

    private static Optional<UnresolvedMavenArtifactException> extractMavenException(Throwable e) {
        if (e instanceof UnresolvedMavenArtifactException) {
            return Optional.of((UnresolvedMavenArtifactException)e);
        }
        if (e.getCause() != null) {
            return GalleonUtils.extractMavenException(e.getCause());
        }
        return Optional.empty();
    }

    public static GalleonBuilder newGalleonBuilder(MavenRepoManager maven, final Consumer<String> resolvedFps) throws ProvisioningException {
        GalleonBuilder provider = new GalleonBuilder();
        if (resolvedFps != null) {
            UniverseResolver.Builder builder = (UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)maven);
            UniverseResolver universeResolver = new UniverseResolver((UniverseResolverBuilder)builder){

                public Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
                    if (fpl.isMavenCoordinates()) {
                        String[] split = fpl.getFPID().getProducer().getName().split(":");
                        resolvedFps.accept(split[0] + ":" + split[1]);
                    }
                    return super.resolve(fpl);
                }
            };
            provider.setUniverseResolver(universeResolver);
        } else {
            provider.addArtifactResolver((RepositoryArtifactResolver)maven);
        }
        return provider;
    }

    public static Provisioning newProvisioning(GalleonBuilder provider, Path installDir, GalleonProvisioningConfig config, Path provisioningFile, boolean useDefaultCore) throws ProvisioningException {
        ProvisioningBuilder pBuilder = useDefaultCore ? provider.newProvisioningBuilder() : (config != null ? provider.newProvisioningBuilder(config) : (Files.exists(provisioningFile, new LinkOption[0]) ? provider.newProvisioningBuilder(provisioningFile) : provider.newProvisioningBuilder()));
        return pBuilder.setMessageWriter((MessageWriter)new LoggingMessageWriter(logger)).setInstallationHome(installDir).build();
    }

    public static List<String> getInstalledPacks(Path dir) throws ProvisioningException {
        try (Provisioning provisioning = new GalleonBuilder().newProvisioningBuilder().build();){
            List list = provisioning.getInstalledPacks(dir);
            return list;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GalleonProvisioningConfig readProvisioningConfig(URI uri) throws MetadataException {
        GalleonProvisioningConfig galleonProvisioningConfig;
        if (CLASSPATH_SCHEME.equals(uri.getScheme())) {
            InputStream is = GalleonUtils.class.getClassLoader().getResourceAsStream(uri.getSchemeSpecificPart());
            return GalleonUtils.loadProvisioningConfig(is);
        }
        if (!FILE_SCHEME.equals(uri.getScheme())) throw new IllegalArgumentException(String.format("Can't use scheme '%s' for Galleon provisioning.xml URI.", uri.getScheme()));
        Provisioning p = new GalleonBuilder().newProvisioningBuilder().build();
        try {
            galleonProvisioningConfig = p.loadProvisioningConfig(Path.of(uri));
            if (p == null) return galleonProvisioningConfig;
        }
        catch (Throwable throwable) {
            try {
                if (p == null) throw throwable;
                try {
                    p.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ProvisioningException e) {
                Optional<XMLStreamException> xmlEx = GalleonUtils.getXmlException(e);
                if (!xmlEx.isPresent()) throw new MetadataException(e.getLocalizedMessage(), e);
                throw ProsperoLogger.ROOT_LOGGER.unableToParseConfigurationUri(uri, e);
            }
            catch (XMLStreamException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToParseConfigurationUri(uri, e);
            }
        }
        p.close();
        return galleonProvisioningConfig;
    }

    @Deprecated(forRemoval=true)
    public static GalleonProvisioningConfig loadProvisioningConfig(InputStream is) throws ProvisioningException, XMLStreamException {
        try (Provisioning p = new GalleonBuilder().newProvisioningBuilder().build();){
            GalleonProvisioningConfig galleonProvisioningConfig = p.loadProvisioningConfig(is);
            return galleonProvisioningConfig;
        }
    }

    @Deprecated(forRemoval=true)
    public static GalleonProvisioningConfig loadProvisioningConfig(URI uri) throws ProvisioningException, XMLStreamException {
        if (CLASSPATH_SCHEME.equals(uri.getScheme())) {
            InputStream is = GalleonUtils.class.getClassLoader().getResourceAsStream(uri.getSchemeSpecificPart());
            return GalleonUtils.loadProvisioningConfig(is);
        }
        if (FILE_SCHEME.equals(uri.getScheme())) {
            GalleonProvisioningConfig galleonProvisioningConfig;
            block11: {
                Provisioning p = new GalleonBuilder().newProvisioningBuilder().build();
                try {
                    galleonProvisioningConfig = p.loadProvisioningConfig(Path.of(uri));
                    if (p == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (p != null) {
                            try {
                                p.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProvisioningException e) {
                        Optional<XMLStreamException> xmlEx = GalleonUtils.getXmlException(e);
                        if (xmlEx.isPresent()) {
                            throw xmlEx.get();
                        }
                        throw e;
                    }
                }
                p.close();
            }
            return galleonProvisioningConfig;
        }
        throw new IllegalArgumentException(String.format("Can't use scheme '%s' for Galleon provisioning.xml URI.", uri.getScheme()));
    }

    private static Optional<XMLStreamException> getXmlException(ProvisioningException rootException) {
        Throwable e = rootException;
        while (e.getCause() != null) {
            if (e.getCause() instanceof XMLStreamException) {
                return Optional.of((XMLStreamException)e.getCause());
            }
            e = e.getCause();
        }
        return Optional.empty();
    }

    public static FsDiff findChanges(Path root) throws ProvisioningException, OperationException {
        MavenOptions mavenOptions = MavenOptions.builder().setOffline(true).setNoLocalCache(true).build();
        try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(root, Collections.emptyList(), new MavenSessionManager(mavenOptions), true).build();){
            FsDiff fsDiff = galleonEnv.getProvisioning().getFsDiff();
            return fsDiff;
        }
    }

    public static interface GalleonExecution {
        public void execute(Map<String, String> var1) throws ProvisioningException;
    }

    public static interface ProvisioningManagerExecution {
        public void execute(Provisioning var1, Map<String, String> var2) throws ProvisioningException;
    }
}

