/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.model;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.FeaturesAddAction;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.model.FeaturePackTemplate;
import org.wildfly.prospero.model.FeaturePackTemplateList;

public class FeaturePackTemplateManager {
    protected static final String FEATURE_PACK_TEMPLATES_YAML = "feature-pack-templates.yaml";
    private final List<FeaturePackTemplate> recipes;

    public FeaturePackTemplateManager() throws MetadataException {
        URL resource = FeaturesAddAction.class.getClassLoader().getResource(FEATURE_PACK_TEMPLATES_YAML);
        try {
            String yaml = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            this.recipes = FeaturePackTemplateList.read(yaml).getRecipes();
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(Path.of(resource.getPath(), new String[0]), e);
        }
    }

    public FeaturePackTemplateManager(FeaturePackTemplateList featurePackRecipeBook) {
        this.recipes = featurePackRecipeBook.getRecipes();
    }

    public FeaturePackTemplate find(String groupId, String artifactId, String version) throws FeatureTemplateVersionMismatchException {
        List matchingRecipes = this.recipes.stream().filter(r -> r.getGroupId().equals(groupId) && r.getArtifactId().equals(artifactId)).collect(Collectors.toList());
        if (matchingRecipes.isEmpty()) {
            return null;
        }
        ArrayList<String> ranges = new ArrayList<String>();
        for (FeaturePackTemplate recipe : matchingRecipes) {
            if (FeaturePackTemplateManager.versionMatches(recipe.getVersion(), version)) {
                return recipe;
            }
            ranges.add(recipe.getVersion());
        }
        throw new FeatureTemplateVersionMismatchException(String.format("Provisioning template for %s:%s is defined only for versions ranges %s", groupId, artifactId, String.join((CharSequence)",", ranges)));
    }

    private static boolean versionMatches(String recipeVersion, String version) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)recipeVersion);
            return versionRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Invalid version pattern in the provisioning template file", e);
        }
    }

    public static class FeatureTemplateVersionMismatchException
    extends OperationException {
        public FeatureTemplateVersionMismatchException(String message) {
            super(message);
        }
    }
}

