/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverseBase;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.xml.MavenProducerSpecXmlParser;
import org.jboss.galleon.universe.maven.xml.ParsedCallbackHandler;
import org.jboss.galleon.util.ZipUtils;

public class MavenUniverse
extends MavenUniverseBase {
    private static final int DEFAULT_CAPACITY = 5;
    private static final String DEFAULT_RANGE = "[0.0,)";
    private Map<String, MavenProducer> producers = new HashMap<String, MavenProducer>(5);
    private boolean fullyLoaded;
    private boolean resolvedLocally;
    private final ParsedCallbackHandler<MavenUniverse, MavenProducer> parsedProducerHandler = new ParsedCallbackHandler<MavenUniverse, MavenProducer>(){

        @Override
        public MavenUniverse getParent() {
            return MavenUniverse.this;
        }

        @Override
        public void parsed(MavenProducer producer) throws XMLStreamException {
            MavenUniverse.this.producers.put(producer.getName(), producer);
        }
    };

    static boolean resolveUniverseArtifact(MavenRepoManager repoManager, MavenArtifact artifact, boolean locallyAvailablePreferred) throws MavenUniverseException {
        if (artifact.getVersionRange() == null) {
            if (artifact.hasVersion()) {
                repoManager.resolve(artifact);
                return false;
            }
            artifact.setVersionRange(DEFAULT_RANGE);
        }
        if (locallyAvailablePreferred) {
            try {
                repoManager.resolveLatestVersion(artifact, true);
                return true;
            }
            catch (MavenUniverseException mavenUniverseException) {
                // empty catch block
            }
        }
        repoManager.resolveLatestVersion(artifact, false);
        return false;
    }

    public MavenUniverse(MavenRepoManager repoManager, MavenArtifact artifact) throws MavenUniverseException {
        this(repoManager, artifact, false);
    }

    public MavenUniverse(MavenRepoManager repoManager, MavenArtifact artifact, boolean absoluteLatest) throws MavenUniverseException {
        super(repoManager, artifact);
        if (artifact.isResolved()) {
            return;
        }
        this.resolvedLocally = MavenUniverse.resolveUniverseArtifact(repoManager, artifact, !absoluteLatest);
    }

    public void refresh() throws MavenUniverseException {
        if (this.fullyLoaded) {
            this.fullyLoaded = false;
            this.producers = new HashMap<String, MavenProducer>(5);
        } else {
            this.producers.clear();
        }
        this.artifact.setPath(null);
        if (this.artifact.getVersionRange() != null) {
            this.repo.resolveLatestVersion(this.artifact, false);
        } else if (this.artifact.hasVersion()) {
            this.repo.resolve(this.artifact);
        } else {
            throw new MavenUniverseException("Universe artifact is missing version and version range: " + this.artifact);
        }
        this.resolvedLocally = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasProducer(String producerName) throws MavenUniverseException {
        if (this.producers.containsKey(producerName)) {
            return true;
        }
        if (this.fullyLoaded) {
            return false;
        }
        try (FileSystem zipfs = ZipUtils.newFileSystem((Path)this.artifact.getPath());){
            Path producerXml = MavenUniverse.getProducerXml(zipfs, producerName);
            if (!Files.exists(producerXml, new LinkOption[0])) {
                boolean bl = false;
                return bl;
            }
            try (BufferedReader reader = Files.newBufferedReader(producerXml);){
                MavenProducerSpecXmlParser.getInstance().parse(reader, this.parsedProducerHandler);
                return true;
            }
            catch (IOException | XMLStreamException e) {
                throw new MavenUniverseException("Failed to read " + producerXml, e);
            }
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to read " + this.artifact.getPath(), e);
        }
    }

    public MavenProducer getProducer(String producerName) throws MavenUniverseException {
        if (!this.hasProducer(producerName)) {
            boolean found = false;
            if (this.resolvedLocally) {
                try {
                    this.refresh();
                }
                catch (MavenUniverseException e) {
                    throw new MavenUniverseException(MavenErrors.msgProducerNotFound(producerName), (Throwable)((Object)e));
                }
                found = this.hasProducer(producerName);
            }
            if (!found) {
                throw MavenErrors.producerNotFound(producerName);
            }
        }
        return this.producers.get(producerName);
    }

    /*
     * Exception decompiling
     */
    public synchronized Collection<MavenProducer> getProducers() throws MavenUniverseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

