/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.universe.maven.xml.MavenParsedProducerCallbackHandler;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class MavenProducerXmlParser10
implements PlugableXmlParser<MavenParsedProducerCallbackHandler> {
    public static final String NS = "urn:jboss:galleon:maven:producer:1.0";
    public static final QName ROOT = new QName("urn:jboss:galleon:maven:producer:1.0", Element.PRODUCER.name);

    public QName getRoot() {
        return ROOT;
    }

    public void readElement(XMLExtendedStreamReader reader, MavenParsedProducerCallbackHandler builder) throws XMLStreamException {
        String name = null;
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    builder.parsedName(name);
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FP_GROUP_ID: {
                            builder.parsedFpGroupId(reader.getElementText());
                            continue block14;
                        }
                        case FP_ARTIFACT_ID: {
                            builder.parsedFpArtifactId(reader.getElementText());
                            continue block14;
                        }
                        case FREQUENCIES: {
                            this.readFrequencies(reader, builder);
                            continue block14;
                        }
                        case DEFAULT_CHANNEL: {
                            builder.parsedDefaultChannel(reader.getElementText());
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void readFrequencies(XMLExtendedStreamReader reader, MavenParsedProducerCallbackHandler builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FREQUENCY: {
                            this.readFrequency(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void readFrequency(XMLExtendedStreamReader reader, MavenParsedProducerCallbackHandler builder) throws XMLStreamException {
        boolean defaultFrequency = false;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case DEFAULT: {
                    defaultFrequency = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        builder.parsedFrequency(reader.getElementText(), defaultFrequency);
    }

    static enum Attribute implements XmlNameProvider
    {
        DEFAULT("default"),
        NAME("name"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<QName, Attribute>(3);
            attributes.put(new QName(Attribute.DEFAULT.name), DEFAULT);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        DEFAULT_CHANNEL("default-channel"),
        FP_ARTIFACT_ID("feature-pack-artifactId"),
        FP_GROUP_ID("feature-pack-groupId"),
        FREQUENCIES("frequencies"),
        FREQUENCY("frequency"),
        PRODUCER("producer"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:maven:producer:1.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(MavenProducerXmlParser10.NS, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return MavenProducerXmlParser10.NS;
        }

        public String toString() {
            return this.name;
        }

        static {
            elements = new HashMap<QName, Element>(7);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.DEFAULT_CHANNEL.name), DEFAULT_CHANNEL);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.FP_ARTIFACT_ID.name), FP_ARTIFACT_ID);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.FP_GROUP_ID.name), FP_GROUP_ID);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.FREQUENCIES.name), FREQUENCIES);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.FREQUENCY.name), FREQUENCY);
            elements.put(new QName(MavenProducerXmlParser10.NS, Element.PRODUCER.name), PRODUCER);
            elements.put(null, UNKNOWN);
        }
    }
}

