/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.InvalidChannelMetadataException;

public class ChannelManifestMapper {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    public static final String SCHEMA_VERSION_1_1_0 = "1.1.0";
    public static final String CURRENT_SCHEMA_VERSION = "1.1.0";
    private static final String SCHEMA_1_0_0_FILE = "org/wildfly/manifest/v1.0.0/schema.json";
    private static final String SCHEMA_1_1_0_FILE = "org/wildfly/manifest/v1.1.0/schema.json";
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory().configure(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR, true);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)YAML_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909)).jsonMapper(OBJECT_MAPPER).build();
    private static final Map<String, JsonSchema> SCHEMAS = new HashMap<String, JsonSchema>();

    private static JsonSchema getSchema(JsonNode node) {
        JsonNode schemaVersion = node.path("schemaVersion");
        String version = schemaVersion.asText();
        if (version == null || version.isEmpty()) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("The manifest does not specify a schemaVersion."));
        }
        JsonSchema schema = SCHEMAS.get(version);
        if (schema == null) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("Unknown schema version " + schemaVersion));
        }
        return schema;
    }

    public static String toYaml(ChannelManifest channelManifest) throws IOException {
        Objects.requireNonNull(channelManifest);
        StringWriter w = new StringWriter();
        OBJECT_MAPPER.writeValue((Writer)w, (Object)channelManifest);
        return w.toString();
    }

    public static ChannelManifest from(URL manifestURL) throws InvalidChannelMetadataException {
        Objects.requireNonNull(manifestURL);
        try {
            List<String> messages;
            if (manifestURL.toString().endsWith("/")) {
                manifestURL = manifestURL.toURI().resolve("channel.yaml").toURL();
            }
            if (!(messages = ChannelManifestMapper.validate(manifestURL)).isEmpty()) {
                throw new InvalidChannelMetadataException("Invalid manifest", messages);
            }
            ChannelManifest channelManifest = (ChannelManifest)OBJECT_MAPPER.readValue(manifestURL, ChannelManifest.class);
            return channelManifest;
        }
        catch (FileNotFoundException e) {
            InvalidChannelMetadataException ice = new InvalidChannelMetadataException("Unable to resolve manifest.", List.of(manifestURL.toString()));
            ice.initCause(e);
            throw ice;
        }
        catch (IOException | URISyntaxException e) {
            throw ChannelManifestMapper.wrapException(e);
        }
    }

    public static ChannelManifest fromString(String yamlContent) throws InvalidChannelMetadataException {
        Objects.requireNonNull(yamlContent);
        try {
            List<String> messages = ChannelManifestMapper.validateString(yamlContent);
            if (!messages.isEmpty()) {
                throw new InvalidChannelMetadataException("Invalid manifest", messages);
            }
            YAMLParser parser = YAML_FACTORY.createParser(yamlContent);
            ChannelManifest channelManifest = (ChannelManifest)OBJECT_MAPPER.readValue((JsonParser)parser, ChannelManifest.class);
            return channelManifest;
        }
        catch (IOException e) {
            throw ChannelManifestMapper.wrapException(e);
        }
    }

    private static List<String> validate(URL url) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(url);
        JsonSchema schema = ChannelManifestMapper.getSchema(node);
        Set validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static List<String> validateString(String yamlContent) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(yamlContent);
        JsonSchema schema = ChannelManifestMapper.getSchema(node);
        Set validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static InvalidChannelMetadataException wrapException(Exception e) {
        InvalidChannelMetadataException ice = new InvalidChannelMetadataException("Invalid Manifest", Collections.singletonList(e.getLocalizedMessage()));
        ice.initCause(e);
        return ice;
    }

    static {
        SCHEMAS.put(SCHEMA_VERSION_1_0_0, SCHEMA_FACTORY.getSchema(ChannelManifestMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_0_0_FILE)));
        SCHEMAS.put("1.1.0", SCHEMA_FACTORY.getSchema(ChannelManifestMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_1_0_FILE)));
    }
}

