/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.util.HashSet;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.ProvisioningProgressEvent;

class DownloadsCallbackAdapter
extends AbstractTransferListener
implements ProgressCallback<MavenArtifact> {
    private final Console console;
    private HashSet<String> resolvedVersionKeys = new HashSet();
    private long totalVolume;
    private long processed;
    private long versionUpdates;
    private boolean currentPhase = false;

    public DownloadsCallbackAdapter(Console console) {
        this.console = console;
    }

    public void starting(ProgressTracker<MavenArtifact> tracker) {
        this.totalVolume = tracker.getTotalVolume();
        this.processed = 0L;
        this.currentPhase = true;
        this.resolvedVersionKeys = new HashSet();
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.STARTING, tracker.getProcessedVolume(), tracker.getTotalVolume());
        if (this.console != null) {
            this.console.progressUpdate(progress);
        }
        ProsperoLogger.ROOT_LOGGER.startedPhase("download artifacts", "" + this.processed);
    }

    public void pulse(ProgressTracker<MavenArtifact> progressTracker) {
    }

    public void complete(ProgressTracker<MavenArtifact> tracker) {
        ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.COMPLETED, tracker.getProcessedVolume(), tracker.getTotalVolume());
        if (this.console != null) {
            this.console.progressUpdate(progress);
        }
        ProsperoLogger.ROOT_LOGGER.completedPhase("download artifacts", "" + this.processed);
        this.totalVolume = 0L;
        this.processed = 0L;
        this.currentPhase = false;
        this.resolvedVersionKeys = new HashSet();
    }

    public void transferSucceeded(TransferEvent event) {
        if (!this.currentPhase) {
            return;
        }
        String item = event.getResource().getResourceName();
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("Downloaded artifact: " + item);
        }
        int fileNameIndex = item.lastIndexOf(File.separator);
        item = item.substring(fileNameIndex + 1);
        if (this.console != null) {
            if ("maven-metadata.xml".equals(item)) {
                String key = event.getResource().getResourceName().substring(0, fileNameIndex);
                if (!this.resolvedVersionKeys.contains(key)) {
                    this.resolvedVersionKeys.add(key);
                    ProvisioningProgressEvent progress = new ProvisioningProgressEvent("RESOLVING_VERSIONS", ProvisioningProgressEvent.EventType.UPDATE, ++this.versionUpdates, this.totalVolume, null, false);
                    this.console.progressUpdate(progress);
                }
            } else {
                ProvisioningProgressEvent progress = new ProvisioningProgressEvent("JB_ARTIFACTS_RESOLVE", ProvisioningProgressEvent.EventType.UPDATE, ++this.processed, this.totalVolume, item, false);
                this.console.progressUpdate(progress);
            }
        }
    }
}

