/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.promotion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.prospero.promotion.CustomArtifact;

public class CustomArtifactList {
    private List<CustomArtifact> artifacts;

    @JsonCreator
    public CustomArtifactList(@JsonProperty(value="artifacts") List<CustomArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public List<CustomArtifact> getArtifacts() {
        return this.artifacts;
    }

    @JsonIgnore
    public List<ArtifactCoordinate> getArtifactCoordinates() {
        return this.artifacts.stream().map(CustomArtifact::toCoordinate).collect(Collectors.toList());
    }

    public static CustomArtifactList readFrom(Path path) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CustomArtifactList)objectMapper.readValue(path.toUri().toURL(), CustomArtifactList.class);
    }

    @JsonIgnore
    public void writeTo(Path path) throws IOException {
        new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue(path.toFile(), (Object)this);
    }

    @JsonIgnore
    public String writeToString() throws IOException {
        StringWriter stringWriter = new StringWriter();
        new ObjectMapper((JsonFactory)new YAMLFactory()).writeValue((Writer)stringWriter, (Object)this);
        return stringWriter.toString();
    }
}

