/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaVersion;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.Version201909;
import com.networknt.schema.Version202012;
import com.networknt.schema.Version4;
import com.networknt.schema.Version6;
import com.networknt.schema.Version7;
import com.networknt.schema.uri.ClasspathURLFactory;
import com.networknt.schema.uri.ClasspathURLFetcher;
import com.networknt.schema.uri.URIFactory;
import com.networknt.schema.uri.URIFetcher;
import com.networknt.schema.uri.URISchemeFactory;
import com.networknt.schema.uri.URISchemeFetcher;
import com.networknt.schema.uri.URITranslator;
import com.networknt.schema.uri.URLFactory;
import com.networknt.schema.uri.URLFetcher;
import com.networknt.schema.urn.URNFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private final ObjectMapper jsonMapper;
    private final YAMLMapper yamlMapper;
    private final String defaultMetaSchemaURI;
    private final URISchemeFactory uriFactory;
    private final URISchemeFetcher uriFetcher;
    private final URITranslator.CompositeURITranslator uriTranslators;
    private final URNFactory urnFactory;
    private final Map<String, JsonMetaSchema> jsonMetaSchemas;
    private final Map<String, String> uriMap;
    private final ConcurrentMap<URI, JsonSchema> uriSchemaCache = new ConcurrentHashMap<URI, JsonSchema>();
    private final boolean forceHttps;
    private final boolean removeEmptyFragmentSuffix;
    private final boolean enableUriSchemaCache;

    private JsonSchemaFactory(ObjectMapper jsonMapper, YAMLMapper yamlMapper, String defaultMetaSchemaURI, URISchemeFactory uriFactory, URISchemeFetcher uriFetcher, URNFactory urnFactory, Map<String, JsonMetaSchema> jsonMetaSchemas, Map<String, String> uriMap, boolean forceHttps, boolean removeEmptyFragmentSuffix, boolean enableUriSchemaCache, URITranslator.CompositeURITranslator uriTranslators) {
        if (jsonMapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        if (yamlMapper == null) {
            throw new IllegalArgumentException("YAMLMapper must not be null");
        }
        if (defaultMetaSchemaURI == null || defaultMetaSchemaURI.trim().isEmpty()) {
            throw new IllegalArgumentException("defaultMetaSchemaURI must not be null or empty");
        }
        if (uriFactory == null) {
            throw new IllegalArgumentException("URIFactory must not be null");
        }
        if (uriFetcher == null) {
            throw new IllegalArgumentException("URIFetcher must not be null");
        }
        if (jsonMetaSchemas == null || jsonMetaSchemas.isEmpty()) {
            throw new IllegalArgumentException("Json Meta Schemas must not be null or empty");
        }
        if (jsonMetaSchemas.get(defaultMetaSchemaURI) == null) {
            throw new IllegalArgumentException("Meta Schema for default Meta Schema URI must be provided");
        }
        if (uriMap == null) {
            throw new IllegalArgumentException("URL Mappings must not be null");
        }
        if (uriTranslators == null) {
            throw new IllegalArgumentException("URI Translators must not be null");
        }
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
        this.defaultMetaSchemaURI = defaultMetaSchemaURI;
        this.uriFactory = uriFactory;
        this.uriFetcher = uriFetcher;
        this.urnFactory = urnFactory;
        this.jsonMetaSchemas = jsonMetaSchemas;
        this.uriMap = uriMap;
        this.forceHttps = forceHttps;
        this.removeEmptyFragmentSuffix = removeEmptyFragmentSuffix;
        this.enableUriSchemaCache = enableUriSchemaCache;
        this.uriTranslators = uriTranslators;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static JsonSchemaFactory getInstance() {
        return JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V4);
    }

    public static JsonSchemaFactory getInstance(SpecVersion.VersionFlag versionFlag) {
        JsonSchemaVersion jsonSchemaVersion = JsonSchemaFactory.checkVersion(versionFlag);
        JsonMetaSchema metaSchema = jsonSchemaVersion.getInstance();
        return JsonSchemaFactory.builder().defaultMetaSchemaURI(metaSchema.getUri()).addMetaSchema(metaSchema).build();
    }

    public static JsonSchemaVersion checkVersion(SpecVersion.VersionFlag versionFlag) {
        JsonSchemaVersion jsonSchemaVersion = null;
        switch (versionFlag) {
            case V202012: {
                jsonSchemaVersion = new Version202012();
                break;
            }
            case V201909: {
                jsonSchemaVersion = new Version201909();
                break;
            }
            case V7: {
                jsonSchemaVersion = new Version7();
                break;
            }
            case V6: {
                jsonSchemaVersion = new Version6();
                break;
            }
            case V4: {
                jsonSchemaVersion = new Version4();
            }
        }
        return jsonSchemaVersion;
    }

    public static Builder builder(JsonSchemaFactory blueprint) {
        Builder builder = JsonSchemaFactory.builder().addMetaSchemas(blueprint.jsonMetaSchemas.values()).defaultMetaSchemaURI(blueprint.defaultMetaSchemaURI).objectMapper(blueprint.jsonMapper).yamlMapper(blueprint.yamlMapper).addUriMappings(blueprint.uriMap);
        for (URITranslator uRITranslator : blueprint.uriTranslators) {
            builder = builder.addUriTranslator(uRITranslator);
        }
        for (Map.Entry entry : blueprint.uriFactory.getURIFactories().entrySet()) {
            builder = builder.uriFactory((URIFactory)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : blueprint.uriFetcher.getURIFetchers().entrySet()) {
            builder = builder.uriFetcher((URIFetcher)entry.getValue(), (String)entry.getKey());
        }
        return builder;
    }

    protected JsonSchema newJsonSchema(URI schemaUri, JsonNode schemaNode, SchemaValidatorsConfig config) {
        ValidationContext validationContext = this.createValidationContext(schemaNode);
        validationContext.setConfig(config);
        return new JsonSchema(validationContext, schemaUri, schemaNode);
    }

    protected ValidationContext createValidationContext(JsonNode schemaNode) {
        JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
        return new ValidationContext(this.uriFactory, this.urnFactory, jsonMetaSchema, this, null);
    }

    private JsonMetaSchema findMetaSchemaForSchema(JsonNode schemaNode) {
        JsonNode uriNode = schemaNode.get("$schema");
        if (uriNode != null && !uriNode.isNull() && !uriNode.isTextual()) {
            throw new JsonSchemaException("Unknown MetaSchema: " + uriNode.toString());
        }
        String uri = uriNode == null || uriNode.isNull() ? this.defaultMetaSchemaURI : JsonSchemaFactory.normalizeMetaSchemaUri(uriNode.textValue(), this.forceHttps, this.removeEmptyFragmentSuffix);
        JsonMetaSchema jsonMetaSchema = this.jsonMetaSchemas.get(uri);
        if (jsonMetaSchema == null) {
            throw new JsonSchemaException("Unknown MetaSchema: " + uri);
        }
        return jsonMetaSchema;
    }

    public URIFactory getUriFactory() {
        return this.uriFactory;
    }

    public URITranslator getUriTranslator() {
        return this.uriTranslators.with(URITranslator.map(this.uriMap));
    }

    public JsonSchema getSchema(String schema, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.jsonMapper.readTree(schema);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(String schema) {
        return this.getSchema(schema, null);
    }

    public JsonSchema getSchema(InputStream schemaStream, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.jsonMapper.readTree(schemaStream);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        return this.getSchema(schemaStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSchema getSchema(URI schemaUri, SchemaValidatorsConfig config) {
        JsonSchema jsonSchema;
        block12: {
            URI mappedUri;
            InputStream inputStream = null;
            URITranslator uriTranslator = null == config ? this.getUriTranslator() : config.getUriTranslator().with(this.getUriTranslator());
            try {
                mappedUri = this.uriFactory.create(uriTranslator.translate(schemaUri).toString());
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to create URI.", e);
                throw new JsonSchemaException(e);
            }
            if (this.enableUriSchemaCache && this.uriSchemaCache.containsKey(mappedUri)) {
                JsonSchema cachedUriSchema = (JsonSchema)this.uriSchemaCache.get(mappedUri);
                cachedUriSchema.getValidationContext().setConfig(config);
                return cachedUriSchema;
            }
            try {
                JsonSchema jsonSchema2;
                inputStream = this.uriFetcher.fetch(mappedUri);
                JsonNode schemaNode = this.isYaml(mappedUri) ? this.yamlMapper.readTree(inputStream) : this.jsonMapper.readTree(inputStream);
                JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
                if (this.idMatchesSourceUri(jsonMetaSchema, schemaNode, schemaUri)) {
                    jsonSchema2 = new JsonSchema(new ValidationContext(this.uriFactory, this.urnFactory, jsonMetaSchema, this, config), mappedUri, schemaNode, true);
                } else {
                    ValidationContext validationContext = this.createValidationContext(schemaNode);
                    validationContext.setConfig(config);
                    jsonSchema2 = new JsonSchema(validationContext, mappedUri, schemaNode);
                }
                if (this.enableUriSchemaCache) {
                    this.uriSchemaCache.put(mappedUri, jsonSchema2);
                }
                jsonSchema = jsonSchema2;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.error("Failed to load json schema!", ioe);
                    throw new JsonSchemaException(ioe);
                }
            }
            inputStream.close();
        }
        return jsonSchema;
    }

    public JsonSchema getSchema(URI schemaUri) {
        return this.getSchema(schemaUri, new SchemaValidatorsConfig());
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(schemaUri, jsonNode, config);
    }

    public JsonSchema getSchema(JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(null, jsonNode, config);
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(schemaUri, jsonNode, null);
    }

    public JsonSchema getSchema(JsonNode jsonNode) {
        return this.newJsonSchema(null, jsonNode, null);
    }

    private boolean idMatchesSourceUri(JsonMetaSchema metaSchema, JsonNode schema, URI schemaUri) {
        String id = metaSchema.readId(schema);
        if (id == null || id.isEmpty()) {
            return false;
        }
        boolean result = id.equals(schemaUri.toString());
        logger.debug("Matching {} to {}: {}", id, schemaUri, result);
        return result;
    }

    private boolean isYaml(URI schemaUri) {
        String schemeSpecificPart = schemaUri.getSchemeSpecificPart();
        int idx = schemeSpecificPart.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        String extension = schemeSpecificPart.substring(idx);
        return ".yml".equals(extension) || ".yaml".equals(extension);
    }

    protected static String normalizeMetaSchemaUri(String u, boolean forceHttps, boolean removeEmptyFragmentSuffix) {
        try {
            URI uri = new URI(u);
            String scheme = forceHttps ? "https" : uri.getScheme();
            URI newUri = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            if (!removeEmptyFragmentSuffix && u.endsWith("#")) {
                return newUri + "#";
            }
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            throw new JsonSchemaException("Wrong MetaSchema URI: " + u);
        }
    }

    public static class Builder {
        private ObjectMapper objectMapper = new ObjectMapper();
        private YAMLMapper yamlMapper = new YAMLMapper();
        private String defaultMetaSchemaURI;
        private final Map<String, URIFactory> uriFactoryMap = new HashMap<String, URIFactory>();
        private final Map<String, URIFetcher> uriFetcherMap = new HashMap<String, URIFetcher>();
        private URNFactory urnFactory;
        private final Map<String, JsonMetaSchema> jsonMetaSchemas = new HashMap<String, JsonMetaSchema>();
        private final Map<String, String> uriMap = new HashMap<String, String>();
        private boolean forceHttps = true;
        private boolean removeEmptyFragmentSuffix = true;
        private boolean enableUriSchemaCache = true;
        private final URITranslator.CompositeURITranslator uriTranslators = new URITranslator.CompositeURITranslator();

        public Builder() {
            URLFactory urlFactory = new URLFactory();
            for (String string : URLFactory.SUPPORTED_SCHEMES) {
                this.uriFactoryMap.put(string, urlFactory);
            }
            URLFetcher urlFetcher = new URLFetcher();
            for (String scheme : URLFetcher.SUPPORTED_SCHEMES) {
                this.uriFetcherMap.put(scheme, urlFetcher);
            }
            ClasspathURLFactory classpathURLFactory = new ClasspathURLFactory();
            ClasspathURLFetcher classpathURLFetcher = new ClasspathURLFetcher();
            for (String scheme : ClasspathURLFactory.SUPPORTED_SCHEMES) {
                this.uriFactoryMap.put(scheme, classpathURLFactory);
                this.uriFetcherMap.put(scheme, classpathURLFetcher);
            }
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder yamlMapper(YAMLMapper yamlMapper) {
            this.yamlMapper = yamlMapper;
            return this;
        }

        public Builder defaultMetaSchemaURI(String defaultMetaSchemaURI) {
            this.defaultMetaSchemaURI = defaultMetaSchemaURI;
            return this;
        }

        public Builder uriFactory(URIFactory uriFactory, String ... schemes) {
            return this.uriFactory(uriFactory, Arrays.asList(schemes));
        }

        public Builder uriFactory(URIFactory uriFactory, Iterable<String> schemes) {
            for (String scheme : schemes) {
                this.uriFactoryMap.put(scheme, uriFactory);
            }
            return this;
        }

        public Builder uriFetcher(URIFetcher uriFetcher, String ... schemes) {
            return this.uriFetcher(uriFetcher, Arrays.asList(schemes));
        }

        public Builder uriFetcher(URIFetcher uriFetcher, Iterable<String> schemes) {
            for (String scheme : schemes) {
                this.uriFetcherMap.put(scheme, uriFetcher);
            }
            return this;
        }

        public Builder addMetaSchema(JsonMetaSchema jsonMetaSchema) {
            this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            return this;
        }

        public Builder addMetaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            for (JsonMetaSchema jsonMetaSchema : jsonMetaSchemas) {
                this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            }
            return this;
        }

        @Deprecated
        public Builder addUriMappings(Map<String, String> map) {
            this.uriMap.putAll(map);
            return this;
        }

        public Builder addUriTranslator(URITranslator translator) {
            if (null != translator) {
                this.uriTranslators.add(translator);
            }
            return this;
        }

        public Builder addUrnFactory(URNFactory urnFactory) {
            this.urnFactory = urnFactory;
            return this;
        }

        public Builder forceHttps(boolean forceHttps) {
            this.forceHttps = forceHttps;
            return this;
        }

        public Builder removeEmptyFragmentSuffix(boolean removeEmptyFragmentSuffix) {
            this.removeEmptyFragmentSuffix = removeEmptyFragmentSuffix;
            return this;
        }

        public Builder enableUriSchemaCache(boolean enableUriSchemaCache) {
            this.enableUriSchemaCache = enableUriSchemaCache;
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this.objectMapper == null ? new ObjectMapper() : this.objectMapper, this.yamlMapper == null ? new YAMLMapper() : this.yamlMapper, this.defaultMetaSchemaURI, new URISchemeFactory(this.uriFactoryMap), new URISchemeFetcher(this.uriFetcherMap), this.urnFactory, this.jsonMetaSchemas, this.uriMap, this.forceHttps, this.removeEmptyFragmentSuffix, this.enableUriSchemaCache, this.uriTranslators);
        }
    }
}

