/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.InstallFolderUtils;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.actions.ProvisioningConfigManipulator;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.License;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.model.FeaturePackTemplate;
import org.wildfly.prospero.model.FeaturePackTemplateManager;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class FeaturesAddAction {
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final InstallationMetadata metadata;
    private final ProsperoConfig prosperoConfig;
    private final Console console;
    private final CandidateActionsFactory candidateActionsFactory;
    private final FeaturePackTemplateManager featurePackTemplateManager;
    private LicenseManager licenseManager;

    public FeaturesAddAction(MavenOptions mavenOptions, Path installDir, List<Repository> repositories, Console console) throws MetadataException, ProvisioningException {
        this(mavenOptions, installDir, repositories, console, new DefaultCandidateActionsFactory(installDir), new FeaturePackTemplateManager(), new LicenseManager());
    }

    FeaturesAddAction(MavenOptions mavenOptions, Path installDir, List<Repository> repositories, Console console, CandidateActionsFactory candidateActionsFactory, FeaturePackTemplateManager featurePackTemplateManager, LicenseManager licenseManager) throws MetadataException, ProvisioningException {
        this.installDir = InstallFolderUtils.toRealPath(installDir);
        this.console = console;
        this.metadata = InstallationMetadata.loadInstallation(this.installDir);
        this.prosperoConfig = this.addTemporaryRepositories(repositories);
        MavenOptions mergedOptions = this.prosperoConfig.getMavenOptions().merge(mavenOptions);
        this.mavenSessionManager = new MavenSessionManager(mergedOptions);
        this.candidateActionsFactory = candidateActionsFactory;
        this.featurePackTemplateManager = featurePackTemplateManager;
        this.licenseManager = licenseManager;
    }

    @Deprecated
    public void addFeaturePack(String featurePackCoord, Set<ConfigId> defaultConfigNames) throws ProvisioningException, OperationException {
        Path candidate = FeaturesAddAction.createTemporaryFolder();
        this.addFeaturePack(featurePackCoord, defaultConfigNames, candidate);
        new ApplyCandidateAction(this.installDir, candidate).applyUpdate(ApplyCandidateAction.Type.FEATURE_ADD);
    }

    public void addFeaturePack(String featurePackCoord, Set<ConfigId> defaultConfigNames, Path candidatePath) throws ProvisioningException, OperationException {
        FeaturesAddAction.verifyFeaturePackCoord(featurePackCoord);
        Objects.requireNonNull(defaultConfigNames);
        candidatePath = InstallFolderUtils.toRealPath(candidatePath);
        FeaturePackLocation fpl = FeaturePackLocationParser.resolveFpl(featurePackCoord);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Adding feature pack " + String.valueOf(fpl));
        }
        Map<String, Set<String>> allLayers = this.getAllLayers(fpl);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Found layers");
            for (String string : allLayers.keySet()) {
                ProsperoLogger.ROOT_LOGGER.trace(string + ": " + StringUtils.join(allLayers.get(string)));
            }
        }
        HashSet<ConfigId> selectedConfigs = new HashSet<ConfigId>();
        Iterator<ConfigId> iterator = defaultConfigNames.iterator();
        while (iterator.hasNext()) {
            ConfigId defaultConfigName;
            String selectedModel = FeaturesAddAction.getSelectedModel((defaultConfigName = iterator.next()) == null ? null : defaultConfigName.getModel(), allLayers);
            String selectedConfig = FeaturesAddAction.getSelectedConfig(defaultConfigName, selectedModel);
            if (selectedConfig == null) continue;
            selectedConfigs.add(new ConfigId(selectedModel, selectedConfig));
        }
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.addingFeaturePack(fpl, StringUtils.join(selectedConfigs, ","), "");
        }
        ProvisioningConfig provisioningConfig = this.buildProvisioningConfig(Collections.emptySet(), fpl, selectedConfigs);
        this.install(featurePackCoord, provisioningConfig, candidatePath);
    }

    @Deprecated
    public void addFeaturePackWithLayers(String featurePackCoord, Set<String> layers, ConfigId configName) throws ProvisioningException, OperationException {
        Path candidate = FeaturesAddAction.createTemporaryFolder();
        this.addFeaturePackWithLayers(featurePackCoord, layers, configName, candidate);
        new ApplyCandidateAction(this.installDir, candidate).applyUpdate(ApplyCandidateAction.Type.FEATURE_ADD);
    }

    public void addFeaturePackWithLayers(String featurePackCoord, Set<String> layers, ConfigId configName, Path candidateFolder) throws ProvisioningException, OperationException {
        Objects.requireNonNull(layers);
        if (layers.isEmpty() && configName != null) {
            throw new IllegalArgumentException("The layers have to be selected if configName is not empty");
        }
        FeaturesAddAction.verifyFeaturePackCoord(featurePackCoord);
        FeaturePackLocation fpl = FeaturePackLocationParser.resolveFpl(featurePackCoord);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Adding feature pack " + String.valueOf(fpl));
        }
        Map<String, Set<String>> allLayers = this.getAllLayers(fpl);
        if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
            ProsperoLogger.ROOT_LOGGER.trace("Found layers");
            for (String key : allLayers.keySet()) {
                ProsperoLogger.ROOT_LOGGER.trace(key + ": " + StringUtils.join(allLayers.get(key)));
            }
        }
        String selectedModel = FeaturesAddAction.getSelectedModel(configName == null ? null : configName.getModel(), allLayers);
        FeaturesAddAction.verifyLayerAvailable(layers, selectedModel, allLayers);
        String selectedConfig = FeaturesAddAction.getSelectedConfig(configName, selectedModel);
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.addingFeaturePack(fpl, selectedConfig + ":" + selectedModel, StringUtils.join(layers));
        }
        ProvisioningConfig newConfig = this.buildProvisioningConfig(layers, fpl, selectedConfig == null ? Collections.emptySet() : Set.of(new ConfigId(selectedModel, selectedConfig)));
        this.install(featurePackCoord, newConfig, candidateFolder);
    }

    public FeaturePackTemplate getFeaturePackRecipe(String featurePackCoord) throws ProvisioningException, OperationException {
        Path tempDirectory = null;
        GalleonEnvironment galleonEnv = null;
        try {
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debug("Looking up version of " + featurePackCoord);
            }
            tempDirectory = Files.createTempDirectory("prospero-temp-target", new FileAttribute[0]);
            galleonEnv = this.getGalleonEnv(tempDirectory);
            ArtifactCoordinate coord = FeaturesAddAction.toMavenCoordinates(featurePackCoord);
            String version = galleonEnv.getChannelSession().findLatestMavenArtifactVersion(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), coord.getVersion()).getVersion();
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.debugf("Found version %s of %s, matching template", (Object)version, (Object)featurePackCoord);
            }
            FeaturePackTemplate featurePackTemplate = this.featurePackTemplateManager.find(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
            return featurePackTemplate;
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (galleonEnv != null) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug("Closing galleon env");
                }
                galleonEnv.close();
            }
            if (tempDirectory != null) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debugf("Removing temporary folder: %s", (Object)tempDirectory);
                }
                FileUtils.deleteQuietly(tempDirectory.toFile());
            }
        }
    }

    public boolean isFeaturePackAvailable(String featurePackCoord) throws OperationException, ProvisioningException {
        ArtifactCoordinate coord = FeaturesAddAction.toMavenCoordinates(featurePackCoord);
        ChannelSession channelSession = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager).build().getChannelSession();
        try {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Resolving a feature pack: " + featurePackCoord);
            }
            channelSession.resolveMavenArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), coord.getVersion());
        }
        catch (NoStreamFoundException e) {
            return false;
        }
        catch (ArtifactTransferException e) {
            throw new ArtifactResolutionException("Unable to resolve feature pack " + featurePackCoord, e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), false);
        }
        return true;
    }

    public List<License> getRequiredLicenses(String featurePackCoord) {
        return this.licenseManager.getLicenses(Set.of(featurePackCoord));
    }

    private static Path createTemporaryFolder() throws ProvisioningException {
        Path candidate;
        try {
            candidate = Files.createTempDirectory("prospero-candidate", new FileAttribute[0]).toAbsolutePath();
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.temporaryCandidateFolder(candidate);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.deleteQuietly(candidate.toFile())));
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        return candidate;
    }

    private static String getSelectedConfig(ConfigId defaultConfigName, String selectedModel) {
        if (defaultConfigName == null || defaultConfigName.getName() == null) {
            if (selectedModel == null) {
                return null;
            }
            return selectedModel + ".xml";
        }
        return defaultConfigName.getName();
    }

    private static void verifyFeaturePackCoord(String featurePackCoord) {
        if (featurePackCoord == null || featurePackCoord.isEmpty()) {
            throw new IllegalArgumentException("The feature pack coordinate cannot be null");
        }
        if (featurePackCoord.split(":").length != 2) {
            throw new IllegalArgumentException("The feature pack coordinate has to consist of <groupId>:<artifactId>");
        }
    }

    private void install(String featurePackCoord, ProvisioningConfig newConfig, Path candidate) throws ProvisioningException, OperationException {
        List<License> pendingLicenses = this.getRequiredLicenses(featurePackCoord);
        this.verifyConfigurationsAvailable(newConfig);
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installDir);){
            metadata.updateProvisioningConfiguration();
        }
        try (PrepareCandidateAction prepareCandidateAction = this.candidateActionsFactory.newPrepareCandidateActionInstance(this.mavenSessionManager, this.prosperoConfig);
             GalleonEnvironment galleonEnv = this.getGalleonEnv(candidate);){
            ProsperoLogger.ROOT_LOGGER.updateCandidateStarted(this.installDir);
            prepareCandidateAction.buildCandidate(candidate, galleonEnv, ApplyCandidateAction.Type.FEATURE_ADD, newConfig);
            ProsperoLogger.ROOT_LOGGER.updateCandidateCompleted(this.installDir);
        }
        try {
            Path existingLicenses = this.installDir.resolve(".installation").resolve("licenses");
            if (Files.exists(existingLicenses, new LinkOption[0])) {
                FileUtils.copyDirectory(existingLicenses.toFile(), candidate.resolve(".installation").resolve("licenses").toFile());
            }
            if (!pendingLicenses.isEmpty()) {
                this.licenseManager.recordAgreements(pendingLicenses, candidate);
            }
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(candidate.resolve("licenses"), e);
        }
    }

    private static ArtifactCoordinate toMavenCoordinates(String featurePackCoord) {
        String[] splitCoordinates;
        if (featurePackCoord == null || featurePackCoord.isEmpty()) {
            throw new IllegalArgumentException("The feature pack coordinate cannot be null");
        }
        if (featurePackCoord.endsWith("::zip")) {
            featurePackCoord = featurePackCoord.substring(0, featurePackCoord.length() - "::zip".length());
        }
        if ((splitCoordinates = featurePackCoord.split(":")).length != 2) {
            throw new IllegalArgumentException("The feature pack coordinate has to consist of <groupId>:<artifactId>");
        }
        ArtifactCoordinate coord = new ArtifactCoordinate(splitCoordinates[0], splitCoordinates[1], "zip", null, "");
        return coord;
    }

    private ProvisioningConfig buildProvisioningConfig(Set<String> layers, FeaturePackLocation fpl, Set<ConfigId> selectedConfigs) throws ProvisioningException, OperationException {
        if (!layers.isEmpty() && selectedConfigs.size() > 1) {
            throw new IllegalArgumentException("Only one config can be selected when selecting layers");
        }
        try (GalleonEnvironment galleonEnv = this.getGalleonEnv(this.installDir);){
            ProvisioningManager pm = galleonEnv.getProvisioningManager();
            try {
                FeaturePackTemplate mapping;
                int fpIndex;
                ProvisioningConfig newConfig;
                ProvisioningConfig existingConfig = pm.getProvisioningConfig();
                ProvisioningConfig.Builder builder = ProvisioningConfig.builder(existingConfig);
                FeaturePackConfig.Builder fpBuilder = FeaturesAddAction.buildFeaturePackConfig(fpl, existingConfig, builder);
                if (!selectedConfigs.isEmpty()) {
                    fpBuilder.setInheritConfigs(false);
                }
                for (ConfigId selectedConfig : selectedConfigs) {
                    if (selectedConfig == null) continue;
                    fpBuilder.setInheritConfigs(false);
                    if (!layers.isEmpty()) {
                        ConfigModel.Builder configBuilder = FeaturesAddAction.buildLayerConfig(layers, selectedConfig.getName(), selectedConfig.getModel(), existingConfig, builder);
                        builder.addConfig(configBuilder.build());
                        continue;
                    }
                    fpBuilder.includeDefaultConfig(selectedConfig.getModel(), selectedConfig.getName());
                }
                if (!layers.isEmpty()) {
                    fpBuilder.setInheritPackages(false);
                }
                if ((newConfig = ((ProvisioningConfig.Builder)builder.addFeaturePackDep(fpIndex = (mapping = this.getFeaturePackRecipe(fpl.getProducerName())) != null ? FeaturesAddAction.applyProvisioningTemplate(fpl, builder, mapping, existingConfig, fpBuilder) : existingConfig.getFeaturePackDeps().size(), fpBuilder.build())).build()).equals(existingConfig)) {
                    throw ProsperoLogger.ROOT_LOGGER.featurePackAlreadyInstalled(fpl);
                }
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        ProvisioningXmlWriter.getInstance().write(newConfig, stringWriter);
                        ProsperoLogger.ROOT_LOGGER.trace("New provisioning configuration: ");
                        ProsperoLogger.ROOT_LOGGER.trace(stringWriter);
                    }
                    catch (Exception e) {
                        ProsperoLogger.ROOT_LOGGER.error("Unable to serialize the modified configuration", e);
                    }
                }
                ProvisioningConfig provisioningConfig = newConfig;
                if (pm != null) {
                    pm.close();
                }
                return provisioningConfig;
            }
            catch (Throwable throwable) {
                if (pm != null) {
                    try {
                        pm.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static int applyProvisioningTemplate(FeaturePackLocation fpl, ProvisioningConfig.Builder builder, FeaturePackTemplate mapping, ProvisioningConfig existingConfig, FeaturePackConfig.Builder fpBuilder) throws ProvisioningException {
        ProvisioningConfigManipulator provisioningConfigManipulator = new ProvisioningConfigManipulator(builder);
        int fpIndex = -1;
        if (mapping.getReplacesDependency() != null) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Replacing %s dependency with %s", (Object)mapping.getReplacesDependency(), (Object)fpl);
            }
            fpIndex = provisioningConfigManipulator.removeFeaturePackDefinition(mapping.getReplacesDependency());
            FeaturePackConfig removedConfig = existingConfig.getFeaturePackDep(FeaturePackLocationParser.resolveFpl(mapping.getReplacesDependency()).getProducer());
            ProvisioningConfigManipulator.copyFeaturePackConfig(fpBuilder, removedConfig);
        } else if (mapping.getTransitiveDependency() != null) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Marking %s as a transitive dependency", (Object)mapping.getTransitiveDependency());
            }
            fpIndex = provisioningConfigManipulator.convertToTransitiveDep(mapping.getTransitiveDependency(), existingConfig);
        } else {
            fpIndex = existingConfig.getFeaturePackDeps().size();
        }
        for (String additionalPackage : mapping.getAdditionalPackages()) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.tracef("Adding additional package %s to %s", (Object)additionalPackage, (Object)fpl);
            }
            if (fpBuilder.isPackageExcluded(additionalPackage)) continue;
            fpBuilder.includePackage(additionalPackage);
        }
        return fpIndex;
    }

    private static FeaturePackConfig.Builder buildFeaturePackConfig(FeaturePackLocation fpl, ProvisioningConfig existingConfig, ProvisioningConfig.Builder builder) throws ProvisioningException {
        FeaturePackConfig.Builder fpBuilder;
        if (existingConfig.hasFeaturePackDep(fpl.getProducer())) {
            FeaturePackConfig fp = existingConfig.getFeaturePackDep(fpl.getProducer());
            fpBuilder = FeaturePackConfig.builder(fp);
            builder.removeFeaturePackDep(fp.getLocation());
        } else {
            fpBuilder = FeaturePackConfig.builder(fpl);
        }
        return fpBuilder;
    }

    private static ConfigModel.Builder buildLayerConfig(Set<String> layers, String selectedConfig, String selectedModel, ProvisioningConfig existingConfig, ProvisioningConfig.Builder builder) throws ProvisioningDescriptionException {
        ConfigModel.Builder configBuilder;
        ConfigId id = new ConfigId(selectedModel, selectedConfig);
        if (existingConfig.hasDefinedConfig(id)) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Replacing existing ConfigModel " + String.valueOf(id));
            }
            ConfigModel cmodel = existingConfig.getDefinedConfig(id);
            configBuilder = ConfigModel.builder(cmodel);
            FeaturesAddAction.includeLayers(layers, configBuilder, cmodel);
            builder.removeConfig(id);
        } else {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Adding new ConfigModel " + String.valueOf(id));
            }
            configBuilder = ConfigModel.builder(selectedModel, selectedConfig);
            for (String layer : layers) {
                configBuilder.includeLayer(layer);
            }
        }
        return configBuilder;
    }

    private static void includeLayers(Set<String> layers, ConfigModel.Builder configBuilder, ConfigModel cmodel) throws ProvisioningDescriptionException {
        for (String layer : layers) {
            if (cmodel.getExcludedLayers().contains(layer)) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Un-excluding layer" + layer);
                }
                configBuilder.removeExcludedLayer(layer);
            }
            if (cmodel.getIncludedLayers().contains(layer)) continue;
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Adding layer " + layer);
            }
            configBuilder.includeLayer(layer);
        }
    }

    private static void verifyLayerAvailable(Set<String> layers, String selectedModel, Map<String, Set<String>> allLayers) throws LayerNotFoundException {
        if (allLayers.isEmpty() && !layers.isEmpty()) {
            String missingLayers = StringUtils.join(layers, ", ");
            throw new LayerNotFoundException(ProsperoLogger.ROOT_LOGGER.layerNotFoundInFeaturePack(missingLayers), layers, Collections.emptySet());
        }
        if (selectedModel != null) {
            Set<String> modelLayers = allLayers.get(selectedModel);
            for (String layer : layers) {
                Set<String> missingLayers = layers.stream().filter(l -> !modelLayers.contains(layer)).collect(Collectors.toSet());
                if (missingLayers.isEmpty()) continue;
                String missingLayersTxt = StringUtils.join(missingLayers, ", ");
                throw new LayerNotFoundException(ProsperoLogger.ROOT_LOGGER.layerNotFoundInFeaturePack(missingLayersTxt), missingLayers, modelLayers);
            }
        }
    }

    private void verifyConfigurationsAvailable(ProvisioningConfig config) throws ProvisioningException, OperationException {
        try (GalleonEnvironment env = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager).build();){
            ChannelMavenArtifactRepositoryManager repositoryManager = env.getRepositoryManager();
            ProvisioningLayoutFactory layoutFactory = GalleonUtils.getProvisioningLayoutFactory(repositoryManager);
            ProvisioningLayout<FeaturePackLayout> layout = layoutFactory.newConfigLayout(config);
            Stream<ConfigId> configIds = Stream.concat(config.getFeaturePackDeps().stream().flatMap(fd -> fd.getIncludedConfigs().stream()), config.getDefinedConfigs().stream().map(ConfigModel::getId));
            Optional<ConfigId> missingConfig = configIds.filter(cfg -> {
                boolean found = true;
                for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                    try {
                        LayoutUtils.getConfigXml(fp.getDir(), cfg, true);
                        found = true;
                        break;
                    }
                    catch (ProvisioningDescriptionException e) {
                        found = false;
                    }
                }
                return !found;
            }).findFirst();
            if (missingConfig.isPresent()) {
                ConfigId cfg2 = missingConfig.get();
                throw new ConfigurationNotFoundException(ProsperoLogger.ROOT_LOGGER.galleonConfigNotFound(cfg2.getModel(), cfg2.getName()), cfg2);
            }
        }
    }

    private static String getSelectedModel(String model, Map<String, Set<String>> allLayers) throws ModelNotDefinedException {
        String selectedModel;
        if (allLayers.isEmpty()) {
            return null;
        }
        if (model == null || model.isEmpty()) {
            if (allLayers.size() > 1) {
                throw new ModelNotDefinedException(ProsperoLogger.ROOT_LOGGER.noDefaultModel(), allLayers.keySet());
            }
            selectedModel = allLayers.keySet().iterator().next();
        } else {
            if (!allLayers.containsKey(model)) {
                throw new ModelNotDefinedException(ProsperoLogger.ROOT_LOGGER.modelNotFoundInFeaturePack(model), model, allLayers.keySet());
            }
            selectedModel = model;
        }
        return selectedModel;
    }

    private GalleonEnvironment getGalleonEnv(Path target) throws ProvisioningException, OperationException {
        return GalleonEnvironment.builder(target, this.prosperoConfig.getChannels(), this.mavenSessionManager).setSourceServerPath(this.installDir).setConsole(this.console).build();
    }

    private Map<String, Set<String>> getAllLayers(FeaturePackLocation fpl) throws ProvisioningException, OperationException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.builder(fpl).build())).build();
        ChannelMavenArtifactRepositoryManager repositoryManager = GalleonEnvironment.builder(this.installDir, this.prosperoConfig.getChannels(), this.mavenSessionManager).build().getRepositoryManager();
        ProvisioningLayoutFactory layoutFactory = GalleonUtils.getProvisioningLayoutFactory(repositoryManager);
        ProvisioningLayout<FeaturePackLayout> layout = layoutFactory.newConfigLayout(config);
        HashMap<String, Set<String>> layersMap = new HashMap<String, Set<String>>();
        for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
            Set<ConfigId> configIds;
            try {
                configIds = fp.loadLayers();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (ConfigId layer : configIds) {
                String model = layer.getModel();
                HashSet<String> names = (HashSet<String>)layersMap.get(model);
                if (names == null) {
                    names = new HashSet<String>();
                    layersMap.put(model, names);
                }
                names.add(layer.getName());
            }
        }
        return layersMap;
    }

    private ProsperoConfig addTemporaryRepositories(List<Repository> repositories) {
        ProsperoConfig prosperoConfig = this.metadata.getProsperoConfig();
        List<Channel> channels = TemporaryRepositoriesHandler.overrideRepositories(prosperoConfig.getChannels(), repositories);
        return new ProsperoConfig(channels, prosperoConfig.getMavenOptions());
    }

    private static class DefaultCandidateActionsFactory
    implements CandidateActionsFactory {
        private final Path installDir;

        public DefaultCandidateActionsFactory(Path installDir) {
            this.installDir = installDir;
        }

        @Override
        public PrepareCandidateAction newPrepareCandidateActionInstance(MavenSessionManager mavenSessionManager, ProsperoConfig prosperoConfig) throws OperationException {
            return new PrepareCandidateAction(this.installDir, mavenSessionManager, prosperoConfig);
        }

        @Override
        public ApplyCandidateAction newApplyCandidateActionInstance(Path candidateDir) throws ProvisioningException, OperationException {
            return new ApplyCandidateAction(this.installDir, candidateDir);
        }
    }

    static interface CandidateActionsFactory {
        public PrepareCandidateAction newPrepareCandidateActionInstance(MavenSessionManager var1, ProsperoConfig var2) throws OperationException;

        public ApplyCandidateAction newApplyCandidateActionInstance(Path var1) throws ProvisioningException, OperationException;
    }

    public static class ConfigurationNotFoundException
    extends OperationException {
        private final String model;
        private final String name;

        public ConfigurationNotFoundException(String msg, ConfigId id) {
            super(msg);
            this.model = id.getModel();
            this.name = id.getName();
        }

        public String getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class FeaturePackAlreadyInstalledException
    extends OperationException {
        public FeaturePackAlreadyInstalledException(String msg) {
            super(msg);
        }
    }

    public static class ModelNotDefinedException
    extends OperationException {
        private String model;
        private Set<String> supportedModels;

        public ModelNotDefinedException(String msg, Set<String> supportedModels) {
            super(msg);
            this.supportedModels = supportedModels;
        }

        public ModelNotDefinedException(String msg, String model, Set<String> supportedModels) {
            super(msg);
            this.model = model;
            this.supportedModels = supportedModels;
        }

        public String getModel() {
            return this.model;
        }

        public Set<String> getSupportedModels() {
            return new TreeSet<String>(this.supportedModels);
        }
    }

    public static class LayerNotFoundException
    extends OperationException {
        private final Set<String> layers;
        private final Set<String> supportedLayers;

        public LayerNotFoundException(String msg, Set<String> layers, Set<String> supportedLayers) {
            super(msg);
            this.layers = layers;
            this.supportedLayers = supportedLayers;
        }

        public Set<String> getLayers() {
            return this.layers;
        }

        public Set<String> getSupportedLayers() {
            return new TreeSet<String>(this.supportedLayers);
        }
    }
}

