/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonUtils;

abstract class GalleonHashesFileWalker {
    private final Path rootPath;

    GalleonHashesFileWalker(Path rootPath) {
        this.rootPath = rootPath;
    }

    public void walk() throws IOException {
        try {
            FsDiff changes = GalleonUtils.findChanges(this.rootPath);
            this.doWalk(changes.getOriginalRoot());
        }
        catch (ProvisioningException e) {
            throw new RuntimeException(e);
        }
        catch (OperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void doWalk(FsEntry root) throws IOException {
        for (FsEntry child : root.getChildren()) {
            if (child.isDiffStatusAdded()) continue;
            if (Files.isDirectory(this.rootPath.resolve(child.getRelativePath()), new LinkOption[0])) {
                this.visitDirectory(Path.of(child.getRelativePath(), new String[0]));
                this.doWalk(child);
                continue;
            }
            this.visitFile(Path.of(child.getRelativePath(), new String[0]));
        }
    }

    abstract void visitFile(Path var1) throws IOException;

    abstract void visitDirectory(Path var1) throws IOException;
}

