/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.InstallFolderUtils;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.exceptions.MetadataException;

public class InstallationExportAction {
    private final Path installationDir;

    public InstallationExportAction(Path installationDir) {
        this.installationDir = InstallFolderUtils.toRealPath(installationDir);
    }

    public static void main(String[] args) throws Exception {
        String installation = args[0];
        String exportName = args[1];
        new InstallationExportAction(Paths.get(installation, new String[0])).export(Paths.get(exportName, new String[0]));
    }

    public void export(Path exportPath) throws IOException, MetadataException {
        if (!this.installationDir.toFile().exists()) {
            throw ProsperoLogger.ROOT_LOGGER.installationDirDoesNotExist(this.installationDir);
        }
        exportPath = InstallFolderUtils.toRealPath(exportPath);
        try (InstallationMetadata metadataBundle = InstallationMetadata.loadInstallation(this.installationDir);){
            metadataBundle.exportMetadataBundle(exportPath);
        }
    }
}

