/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ManifestVersionResolver;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import org.wildfly.prospero.wfchannel.ResolvedArtifactsStore;

class ProsperoManifestVersionResolver {
    private static final Logger LOG = Logger.getLogger(ProsperoManifestVersionResolver.class.getName());
    private final ResolvedArtifactsStore manifestVersions;
    private final Supplier<ManifestVersionResolver> manifestVersionResolver;

    ProsperoManifestVersionResolver(MavenSessionManager mavenSessionManager) {
        this.manifestVersions = mavenSessionManager.getResolvedArtifactVersions();
        this.manifestVersionResolver = () -> new ManifestVersionResolver(mavenSessionManager.getProvisioningRepo(), mavenSessionManager.newRepositorySystem());
    }

    ProsperoManifestVersionResolver(ResolvedArtifactsStore manifestVersions, ManifestVersionResolver manifestVersionResolver) {
        this.manifestVersions = manifestVersions;
        this.manifestVersionResolver = () -> manifestVersionResolver;
    }

    public ManifestVersionRecord getCurrentVersions(List<Channel> channels) throws IOException {
        ManifestVersionRecord record = new ManifestVersionRecord();
        ArrayList<Channel> fallbackChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            if (channel.getManifestCoordinate().getMaven() != null && channel.getManifestCoordinate().getMaven().getVersion() == null) {
                MavenArtifact version;
                MavenCoordinate manifestCoord = channel.getManifestCoordinate().getMaven();
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Trying to lookup manifest %s", (Object)manifestCoord);
                }
                if ((version = this.manifestVersions.getManifestVersion(manifestCoord.getGroupId(), manifestCoord.getArtifactId())) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Failed to lookup manifest %s in currently resolved artifacts", (Object)manifestCoord);
                    }
                    fallbackChannels.add(channel);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Manifest %s resolved in currently resolve artifacts, recording.", (Object)manifestCoord);
                }
                String description = ChannelManifestMapper.from(version.getFile().toURI().toURL()).getDescription();
                record.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoord.getGroupId(), manifestCoord.getArtifactId(), version.getVersion(), description));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Manifest for channel %s will be resolved via fallback.", (Object)channel.getName());
            }
            fallbackChannels.add(channel);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Resolving channel manifests using fallback mechanisms.", new Object[0]);
        }
        ManifestVersionRecord currentVersions = this.manifestVersionResolver.get().getCurrentVersions(fallbackChannels);
        currentVersions.getMavenManifests().forEach(record::addManifest);
        currentVersions.getOpenManifests().forEach(record::addManifest);
        currentVersions.getUrlManifests().forEach(record::addManifest);
        return record;
    }
}

