/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class TemporaryFilesManager
implements AutoCloseable {
    private final Set<Path> temporaryFiles = new HashSet<Path>();

    TemporaryFilesManager() {
    }

    public static TemporaryFilesManager getInstance() {
        return new TemporaryFilesManager();
    }

    public Path createTempDirectory(String prefix) throws IOException {
        Path tempDirectory = Files.createTempDirectory(prefix, new FileAttribute[0]);
        tempDirectory.toFile().deleteOnExit();
        this.temporaryFiles.add(tempDirectory);
        return tempDirectory;
    }

    public Path createTempFile(String prefix, String suffix) throws IOException {
        Path tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        this.temporaryFiles.add(tempFile);
        return tempFile;
    }

    @Override
    public void close() {
        this.temporaryFiles.stream().map(Path::toFile).forEach(FileUtils::deleteQuietly);
    }
}

