/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.util.List;
import org.apache.commons.text.WordUtils;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.licenses.License;

public class LicensePrinter {
    private final CliConsole console;

    public LicensePrinter(CliConsole console) {
        this.console = console;
    }

    public void print(List<License> pendingLicenses) {
        if (!pendingLicenses.isEmpty()) {
            boolean first = true;
            for (License pendingLicense : pendingLicenses) {
                String[] lines;
                if (!first) {
                    this.console.println("");
                }
                first = false;
                this.console.println("===============");
                this.console.println(pendingLicense.getTitle());
                this.console.println("===============");
                String text = pendingLicense.getText();
                for (String line : lines = text.split("\n")) {
                    this.console.println("  " + WordUtils.wrap(line, 118, System.lineSeparator() + "  ", true));
                }
                this.console.println("===============");
            }
            this.console.println("");
        }
    }
}

