/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliMessages;

public class RepositoryDefinition {
    public static List<Repository> from(List<String> repos) throws ArgumentParsingException {
        ArrayList<Repository> repositories = new ArrayList<Repository>(repos.size());
        for (int i = 0; i < repos.size(); ++i) {
            String repoUri;
            Object repoId;
            String repoInfo = repos.get(i);
            if (repoInfo.contains("::")) {
                String[] parts = repoInfo.split("::");
                if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
                    throw CliMessages.MESSAGES.invalidRepositoryDefinition(repoInfo);
                }
                repoId = parts[0];
                repoUri = RepositoryDefinition.parseRepositoryLocation(parts[1], true);
            } else {
                if (StringUtils.isBlank(repoInfo)) {
                    throw CliMessages.MESSAGES.invalidRepositoryDefinition(repoInfo);
                }
                repoId = "temp-repo-" + i;
                repoUri = RepositoryDefinition.parseRepositoryLocation(repoInfo, true);
            }
            repositories.add(new Repository((String)repoId, repoUri));
        }
        return repositories;
    }

    static String parseRepositoryLocation(String location, boolean checkLocalPathExists) throws ArgumentParsingException {
        URI uri;
        try {
            uri = new URI(location);
            if (("file".equals(uri.getScheme()) || StringUtils.isBlank(uri.getScheme())) && StringUtils.isBlank(uri.getHost())) {
                uri = !uri.isOpaque() && StringUtils.isNotBlank(uri.getScheme()) ? RepositoryDefinition.normalizeLocalPath(Path.of(uri), checkLocalPathExists).toUri() : RepositoryDefinition.normalizeLocalPath(Path.of(uri.getSchemeSpecificPart(), new String[0]), checkLocalPathExists).toUri();
            }
            uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            try {
                Path path = Path.of(location, new String[0]);
                uri = RepositoryDefinition.normalizeLocalPath(path, checkLocalPathExists).toUri();
            }
            catch (InvalidPathException e2) {
                throw CliMessages.MESSAGES.invalidFilePath(location, e);
            }
        }
        catch (IllegalArgumentException e) {
            throw CliMessages.MESSAGES.invalidFilePath(location, e);
        }
        try {
            return uri.toURL().toExternalForm();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw CliMessages.MESSAGES.invalidFilePath(location, e);
        }
    }

    private static Path normalizeLocalPath(Path path, boolean checkPathExists) throws ArgumentParsingException {
        Path normalized = path.toAbsolutePath().normalize();
        if (checkPathExists && !Files.exists(path, new LinkOption[0])) {
            throw CliMessages.MESSAGES.nonExistingFilePath(normalized);
        }
        return normalized;
    }
}

