/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.printers.ChannelPrinter;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import picocli.CommandLine;

@CommandLine.Command(name="channel")
public class ChannelCommand
extends AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public ChannelCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.console.getErrOut());
        return 2;
    }

    @CommandLine.Command(name="versions")
    public static class ChannelVersionCommand
    extends AbstractCommand {
        protected static final String PREFIX = "  * ";
        @CommandLine.Option(names={"--dir"})
        private Optional<Path> directory;

        public ChannelVersionCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            Path installationDir = ChannelVersionCommand.determineInstallationDirectory(this.directory);
            this.console.println(CliMessages.MESSAGES.serverVersionsHeader());
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDir);){
                ManifestVersionRecord channelVersions = metadataAction.getChannelVersions();
                for (ManifestVersionRecord.MavenManifest mavenManifest : channelVersions.getMavenManifests()) {
                    if (mavenManifest.getDescription() != null) {
                        this.console.println(PREFIX + mavenManifest.getDescription());
                        continue;
                    }
                    this.console.println(PREFIX + ChannelVersionCommand.buildManifestGav(mavenManifest));
                }
                for (ManifestVersionRecord.UrlManifest urlManifest : channelVersions.getUrlManifests()) {
                    if (urlManifest.getDescription() != null) {
                        this.console.println(PREFIX + urlManifest.getDescription());
                        continue;
                    }
                    this.console.println(PREFIX + String.format("%s [%s]", urlManifest.getUrl(), urlManifest.getHash()));
                }
            }
            return 0;
        }

        private static String buildManifestGav(ManifestVersionRecord.MavenManifest mavenManifest) {
            return String.format("%s:%s [%s]", mavenManifest.getGroupId(), mavenManifest.getArtifactId(), mavenManifest.getVersion());
        }
    }

    @CommandLine.Command(name="list")
    public static class ChannelListCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"})
        Optional<Path> directory;

        public ChannelListCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            List<Channel> channels;
            Path installationDirectory = ChannelListCommand.determineInstallationDirectory(this.directory);
            this.console.println(CliMessages.MESSAGES.listChannels(installationDirectory));
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
                channels = metadataAction.getChannels();
            }
            ChannelPrinter channelPrinter = new ChannelPrinter(this.console);
            this.console.println("-------");
            for (Channel channel : channels) {
                channelPrinter.print(channel);
                this.console.println("-------");
            }
            return 0;
        }
    }
}

