/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.channel;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="add", sortOptions=false)
public class ChannelAddCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--channel-name"}, required=true)
    private String channelName;
    @CommandLine.Option(names={"--manifest"}, required=true)
    private String gavUrlOrPath;
    @CommandLine.Option(names={"--dir"})
    private Optional<Path> directory;
    @CommandLine.Option(names={"--repositories"}, split=",", paramLabel="<repo-url>", required=true)
    private List<String> repositoryDefs;

    public ChannelAddCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Path installationDirectory = ChannelAddCommand.determineInstallationDirectory(this.directory);
        this.console.println(CliMessages.MESSAGES.subscribeChannel(installationDirectory, this.channelName));
        ChannelManifestCoordinate manifest = ArtifactUtils.manifestCoordFromString(this.gavUrlOrPath);
        try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
            List<Repository> repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.repositoryDefs), temporaryFiles);
            Channel channel = new Channel(this.channelName, null, null, repositories, manifest, null, null);
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
                metadataAction.addChannel(channel);
            }
        }
        this.console.println(CliMessages.MESSAGES.channelAdded(this.channelName));
        return 0;
    }
}

