/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.channel;

import java.nio.file.Path;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="remove")
public class ChannelRemoveCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--channel-name"}, required=true)
    String channelName;
    @CommandLine.Option(names={"--dir"})
    Optional<Path> directory;

    public ChannelRemoveCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Path installationDirectory = ChannelRemoveCommand.determineInstallationDirectory(this.directory);
        this.console.println(CliMessages.MESSAGES.unsubscribeChannel(installationDirectory, this.channelName));
        try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
            Optional<Channel> channel = metadataAction.getChannels().stream().filter(c -> c.getName().equals(this.channelName)).findFirst();
            if (channel.isEmpty()) {
                this.console.println(CliMessages.MESSAGES.channelNotFound());
                Integer n = 2;
                return n;
            }
            metadataAction.removeChannel(this.channelName);
            this.console.println(CliMessages.MESSAGES.channelRemoved(this.channelName));
            Integer n = 0;
            return n;
        }
    }
}

