/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import org.jboss.galleon.MessageWriter;
import org.jboss.logging.Logger;

class LoggingMessageWriter
implements MessageWriter {
    private final Logger logger;

    LoggingMessageWriter(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void verbose(Throwable cause, CharSequence message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)message, cause);
        }
    }

    @Override
    public void print(Throwable cause, CharSequence message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)message, cause);
        }
    }

    @Override
    public void error(Throwable cause, CharSequence message) {
        this.logger.error((Object)message, cause);
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void close() throws Exception {
    }
}

