/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.util.CollectionUtils;

public class FsEntryFactory {
    private static final String FILTERED_PATH_DOT_GALLEON = "/.galleon";
    private static final String FILTERED_PATH_GLNEW_EXT = "*.glnew";
    private List<PathFilter> pathFilters = Collections.emptyList();

    public static FsEntryFactory getInstance() {
        return new FsEntryFactory();
    }

    private FsEntryFactory() {
    }

    public FsEntry forPath(Path p) throws ProvisioningException {
        FsEntry entry = new FsEntry(null, p);
        if (entry.dir) {
            try {
                this.initChildren(entry);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.fsEntryInit(p), e);
            }
        }
        return entry;
    }

    private void initChildren(FsEntry parent) throws IOException {
        boolean hasDirs = false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent.p);){
            for (Path c : stream) {
                if (!this.pathFilters.isEmpty() && this.isFiltered(parent, c.getFileName().toString())) continue;
                hasDirs |= new FsEntry((FsEntry)parent, (Path)c).dir;
            }
        }
        if (hasDirs) {
            for (FsEntry child : parent.getChildren()) {
                if (!child.dir || !Files.isReadable(child.p)) continue;
                this.initChildren(child);
            }
        }
    }

    private boolean isFiltered(FsEntry parent, String childName) {
        if (this.pathFilters.isEmpty()) {
            return false;
        }
        for (PathFilter filter : this.pathFilters) {
            if (!filter.matches(parent, childName)) continue;
            return true;
        }
        return false;
    }

    public FsEntryFactory filterGalleonPaths() {
        this.filter(FILTERED_PATH_DOT_GALLEON);
        this.filter(FILTERED_PATH_GLNEW_EXT);
        return this;
    }

    public FsEntryFactory filter(String pathExpr) {
        String[] entries;
        boolean relative = true;
        if (pathExpr.isEmpty()) {
            relative = false;
            entries = new String[]{};
        } else if (pathExpr.charAt(0) == '/') {
            relative = false;
            entries = pathExpr.substring(1).split("/");
        } else {
            entries = pathExpr.split("/");
        }
        this.pathFilters = CollectionUtils.add(this.pathFilters, new PathFilter(entries, relative));
        return this;
    }

    private static class PathFilter {
        final String[] pathElements;
        final boolean relative;
        final String suffix;
        final FsEntry[] checkEntries;

        PathFilter(String[] pathElements, boolean relative) {
            this.pathElements = pathElements;
            this.relative = relative;
            if (pathElements.length > 0) {
                String tmp = pathElements[pathElements.length - 1];
                if (tmp.charAt(0) == '*') {
                    tmp = tmp.substring(1);
                }
                this.suffix = tmp;
            } else {
                this.suffix = null;
            }
            this.checkEntries = pathElements.length - 1 <= 0 ? null : new FsEntry[pathElements.length - 1];
        }

        boolean matches(FsEntry parent, String childName) {
            if (this.checkEntries != null) {
                Arrays.fill(this.checkEntries, null);
            }
            if (this.relative) {
                if (this.pathElements.length > parent.depth + 1) {
                    return false;
                }
                int i = this.pathElements.length - 1;
                if (i > 0) {
                    FsEntry checkEntry = parent;
                    do {
                        if (checkEntry == null) {
                            return false;
                        }
                        this.checkEntries[i - 1] = checkEntry;
                        checkEntry = checkEntry.parent;
                    } while (--i > 0);
                }
            } else if (this.pathElements.length == parent.depth + 1) {
                if (parent.depth > 0) {
                    FsEntry checkEntry = parent;
                    int i = this.checkEntries.length - 1;
                    this.checkEntries[i] = checkEntry;
                    while (checkEntry.depth > 1) {
                        checkEntry = checkEntry.parent;
                        this.checkEntries[--i] = checkEntry;
                    }
                }
            } else {
                return false;
            }
            if (this.pathElements.length == 0) {
                return true;
            }
            int i = 0;
            while (i < this.pathElements.length - 1) {
                if (this.checkEntries[i].name.equals(this.pathElements[i++])) continue;
                return false;
            }
            return childName.endsWith(this.suffix);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (!this.relative) {
                buf.append('/');
            }
            if (this.pathElements.length > 0) {
                buf.append(this.pathElements[0]);
                for (int i = 1; i < this.pathElements.length; ++i) {
                    buf.append('/').append(this.pathElements[i]);
                }
            }
            return buf.toString();
        }
    }
}

