/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.channel.ManifestRequirement;
import org.wildfly.channel.Stream;

public class ChannelManifest {
    public static final String CLASSIFIER = "manifest";
    public static final String EXTENSION = "yaml";
    private final String schemaVersion;
    private final String name;
    private final String id;
    private final String description;
    private Set<Stream> streams;
    private List<ManifestRequirement> manifestRequirements;

    public ChannelManifest(String name, String id, String description, Collection<Stream> streams) {
        this("1.0.0", name, id, description, Collections.emptyList(), streams);
    }

    public ChannelManifest(String name, String id, String description, Collection<ManifestRequirement> manifestRequirements, Collection<Stream> streams) {
        this("1.0.0", name, id, description, manifestRequirements, streams);
    }

    @JsonCreator
    @JsonPropertyOrder(value={"schemaVersion", "name", "description", "streams"})
    public ChannelManifest(@JsonProperty(value="schemaVersion", required=true) String schemaVersion, @JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="requires") Collection<ManifestRequirement> manifestRequirements, @JsonProperty(value="streams") Collection<Stream> streams) {
        this.schemaVersion = schemaVersion;
        this.name = name;
        this.id = id;
        this.description = description;
        this.manifestRequirements = new ArrayList<ManifestRequirement>();
        if (manifestRequirements != null) {
            this.manifestRequirements.addAll(manifestRequirements);
        }
        this.streams = new TreeSet<Stream>();
        if (streams != null) {
            this.streams.addAll(streams);
        }
    }

    @JsonInclude
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="requires")
    public List<ManifestRequirement> getManifestRequirements() {
        return this.manifestRequirements;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Collection<Stream> getStreams() {
        return this.streams;
    }

    public Optional<Stream> findStreamFor(String groupId, String artifactId) {
        Optional<Stream> stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals(artifactId)).findFirst();
        if (stream.isPresent()) {
            return stream;
        }
        stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals("*")).findFirst();
        return stream;
    }

    public String toString() {
        return "ChannelManifest{schemaVersion='" + this.schemaVersion + "', name='" + this.name + "', id='" + this.id + "', description='" + this.description + "', streams=" + this.streams + ", manifestRequirements=" + this.manifestRequirements + "}";
    }
}

