/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.util.Objects;
import java.util.Optional;

public class VersionResult {
    private final String version;
    private final Optional<String> channelName;

    public VersionResult(String version, String channelName) {
        Objects.requireNonNull(version);
        this.version = version;
        this.channelName = Optional.ofNullable(channelName);
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getChannelName() {
        return this.channelName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionResult that = (VersionResult)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.channelName, that.channelName);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.channelName);
    }

    public String toString() {
        return "VersionResult{version='" + this.version + "', channelName='" + this.channelName + "'}";
    }
}

