/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero;

import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ProvisioningAction;

public class VersionLogger {
    private static volatile boolean logged = false;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logVersionOnStartup() {
        if (!logged) {
            Object object = lock;
            synchronized (object) {
                if (!logged) {
                    logged = true;
                    try {
                        ProsperoLogger.ROOT_LOGGER.info(" version: " + VersionLogger.getVersion());
                    }
                    catch (Exception e) {
                        ProsperoLogger.ROOT_LOGGER.warn("Unable to read the prospero version", e);
                    }
                }
            }
        }
    }

    public static String getVersion() throws Exception {
        Enumeration<URL> resources = ProvisioningAction.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            String specTitle = manifest.getMainAttributes().getValue("Specification-Title");
            if (!"Prospero Common".equals(specTitle) && !"Prospero CLI".equals(specTitle)) continue;
            return StringUtils.join(manifest.getMainAttributes().getValue("Implementation-Version"));
        }
        return "unknown";
    }
}

