/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;

class ProvisioningConfigManipulator {
    private final ProvisioningConfig.Builder configBuilder;

    public ProvisioningConfigManipulator(ProvisioningConfig.Builder configBuilder) {
        this.configBuilder = configBuilder;
    }

    int removeFeaturePackDefinition(String fpName) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(depFpl.getLocation());
        return fpIndex;
    }

    int convertToTransitiveDep(String fpName, ProvisioningConfig originalConfig) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        FeaturePackConfig oldConfig = originalConfig.getFeaturePackDep(depFpl);
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(oldConfig.getLocation());
        FeaturePackConfig.Builder newFpBuilder = FeaturePackConfig.transitiveBuilder(oldConfig.getLocation());
        ProvisioningConfigManipulator.copyFeaturePackConfig(newFpBuilder, oldConfig);
        this.configBuilder.addFeaturePackDep(newFpBuilder.build());
        return fpIndex;
    }

    static void copyFeaturePackConfig(FeaturePackConfig.Builder configBuilder, FeaturePackConfig originalConfig) throws ProvisioningDescriptionException {
        if (originalConfig.getInheritPackages() != null) {
            configBuilder.setInheritPackages(originalConfig.getInheritPackages());
        }
        for (String string : originalConfig.getExcludedPackages()) {
            configBuilder.excludePackage(string);
        }
        for (String string : originalConfig.getIncludedPackages()) {
            configBuilder.includePackage(string);
        }
        for (FeaturePackLocation.FPID fPID : originalConfig.getPatches()) {
            configBuilder.addPatch(fPID);
        }
        if (originalConfig.getInheritConfigs() != null) {
            configBuilder.setInheritConfigs(originalConfig.getInheritConfigs());
        }
        configBuilder.setInheritModelOnlyConfigs(originalConfig.isInheritModelOnlyConfigs());
        for (String string : originalConfig.getFullModelsIncluded()) {
            configBuilder.includeConfigModel(string);
        }
        for (String string : originalConfig.getFullModelsExcluded().keySet()) {
            configBuilder.excludeConfigModel(string);
        }
        for (ConfigId configId : originalConfig.getIncludedConfigs()) {
            configBuilder.includeDefaultConfig(configId);
        }
        for (ConfigId configId : originalConfig.getExcludedConfigs()) {
            configBuilder.excludeDefaultConfig(configId);
        }
        for (ConfigModel configModel : originalConfig.getDefinedConfigs()) {
            configBuilder.addConfig(configModel);
        }
    }
}

