/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class MavenOptions {
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory().configure(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR, true);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(YAML_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private final Optional<Path> localCache;
    private final Optional<Boolean> offline;
    private final Optional<Boolean> noLocalCache;
    public static final MavenOptions DEFAULT_OPTIONS = MavenOptions.builder().build();
    public static final MavenOptions OFFLINE_NO_CACHE = MavenOptions.builder().setOffline(true).setNoLocalCache(true).build();
    public static final MavenOptions OFFLINE = MavenOptions.builder().setOffline(true).build();

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    private MavenOptions(@JsonProperty(value="localCache") Path localCache, @JsonProperty(value="offline") boolean offline, @JsonProperty(value="noLocalCache") boolean noLocalCache) {
        this.localCache = Optional.ofNullable(localCache).map(Path::toAbsolutePath);
        this.noLocalCache = Optional.of(noLocalCache);
        this.offline = Optional.of(offline);
    }

    private MavenOptions(Optional<Path> localCache, Optional<Boolean> offline, Optional<Boolean> noLocalCache) {
        this.localCache = localCache;
        this.noLocalCache = noLocalCache;
        this.offline = offline;
    }

    public Path getLocalCache() {
        return this.localCache.orElse(null);
    }

    public boolean isOffline() {
        return this.offline.orElse(false);
    }

    public boolean isNoLocalCache() {
        return this.noLocalCache.orElseGet(this.localCache::isEmpty);
    }

    public boolean overridesLocalCache() {
        return this.localCache.isPresent();
    }

    public String toString() {
        return "MavenOptions{localCache=" + this.localCache + ", offline=" + this.offline + ", noLocalCache=" + this.noLocalCache + "}";
    }

    public MavenOptions merge(MavenOptions override) {
        Builder builder = MavenOptions.builder();
        if (override.offline.isPresent()) {
            builder.setOffline(override.isOffline());
        } else if (this.offline.isPresent()) {
            builder.setOffline(this.isOffline());
        }
        if (override.noLocalCache.isPresent()) {
            builder.setNoLocalCache(override.isNoLocalCache());
        } else if (this.noLocalCache.isPresent()) {
            builder.setNoLocalCache(this.isNoLocalCache());
        }
        if (override.localCache.isPresent()) {
            builder.setLocalCachePath(override.getLocalCache());
        } else if (this.localCache.isPresent()) {
            builder.setLocalCachePath(this.getLocalCache());
        }
        return builder.build();
    }

    public void write(Path target) throws IOException {
        StringWriter w = new StringWriter();
        OBJECT_MAPPER.writeValue(w, (Object)this);
        Files.writeString(target, (CharSequence)w.toString(), new OpenOption[0]);
    }

    public static MavenOptions read(Path target) throws IOException {
        return OBJECT_MAPPER.readValue(target.toFile(), MavenOptions.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenOptions that = (MavenOptions)o;
        return Objects.equals(this.localCache, that.localCache) && Objects.equals(this.offline, that.offline) && Objects.equals(this.noLocalCache, that.noLocalCache);
    }

    public int hashCode() {
        return Objects.hash(this.localCache, this.offline, this.noLocalCache);
    }

    public static class Builder {
        private Optional<Boolean> offline = Optional.empty();
        private Optional<Boolean> noLocalCache = Optional.empty();
        private Optional<Path> localCachePath = Optional.empty();

        private Builder() {
        }

        public MavenOptions build() {
            return new MavenOptions(this.localCachePath, this.offline, this.noLocalCache);
        }

        public Builder setOffline(boolean offline) {
            this.offline = Optional.of(offline);
            return this;
        }

        public Builder setNoLocalCache(boolean noLocalCache) {
            this.noLocalCache = Optional.of(noLocalCache);
            return this;
        }

        public Builder setLocalCachePath(Path localCachePath) {
            this.localCachePath = Optional.of(localCachePath);
            return this;
        }
    }
}

