/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

class UnknownCommandParameterExceptionHandler
implements CommandLine.IParameterExceptionHandler {
    protected static final String COMMAND_SEPARATOR = " ";
    private final CommandLine.IParameterExceptionHandler delegate;
    private final PrintStream writer;

    public UnknownCommandParameterExceptionHandler(CommandLine.IParameterExceptionHandler delegate, PrintStream writer) {
        this.delegate = delegate;
        this.writer = writer;
    }

    @Override
    public int handleParseException(CommandLine.ParameterException ex, String[] args) throws Exception {
        if (ex instanceof CommandLine.UnmatchedArgumentException) {
            CommandLine.UnmatchedArgumentException argEx = (CommandLine.UnmatchedArgumentException)ex;
            if (argEx.isUnknownOption()) {
                return this.delegate.handleParseException(ex, args);
            }
            if (!UnknownCommandParameterExceptionHandler.currentCommandHasSubcommands(argEx)) {
                return this.delegate.handleParseException(ex, args);
            }
            CommandLine.Help.ColorScheme colorScheme = CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.AUTO);
            String commandName = argEx.getCommandLine().getCommandSpec().name();
            String fullCommand = commandName + COMMAND_SEPARATOR + StringUtils.join(argEx.getUnmatched(), COMMAND_SEPARATOR);
            this.writer.println(colorScheme.errorText(CliMessages.MESSAGES.unknownCommand(fullCommand)));
            List<String> suggestions = argEx.getSuggestions();
            if (suggestions.isEmpty()) {
                argEx.getCommandLine().usage(this.writer);
            } else {
                this.writer.printf(CliMessages.MESSAGES.commandSuggestions(this.prefix(commandName, suggestions)), new Object[0]);
            }
            return 2;
        }
        return this.delegate.handleParseException(ex, args);
    }

    private static boolean currentCommandHasSubcommands(CommandLine.UnmatchedArgumentException argEx) {
        return !argEx.getCommandLine().getParseResult().commandSpec().subcommands().isEmpty();
    }

    private List<String> prefix(String commandName, List<String> commandSuggestions) {
        return commandSuggestions.stream().map(s -> commandName + COMMAND_SEPARATOR + s).collect(Collectors.toList());
    }
}

