/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.actions.ProvisioningAction;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.LicensePrinter;
import org.wildfly.prospero.cli.commands.AbstractInstallCommand;
import org.wildfly.prospero.licenses.License;
import picocli.CommandLine;

@CommandLine.Command(name="print-licenses", sortOptions=false)
public class PrintLicensesCommand
extends AbstractInstallCommand {
    public PrintLicensesCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.newInstance();){
            Path tempDirectory = temporaryFiles.createTempDirectory("tmp-installer");
            ProvisioningDefinition provisioningDefinition = this.buildDefinition(temporaryFiles);
            MavenOptions mavenOptions = this.getMavenOptions();
            ProvisioningConfig provisioningConfig = provisioningDefinition.toProvisioningConfig();
            List<Channel> channels = this.resolveChannels(provisioningDefinition, mavenOptions);
            ProvisioningAction provisioningAction = this.actionFactory.install(tempDirectory.toAbsolutePath(), mavenOptions, this.console);
            List<License> pendingLicenses = provisioningAction.getPendingLicenses(provisioningConfig, channels);
            if (!pendingLicenses.isEmpty()) {
                this.console.println("");
                this.console.println(CliMessages.MESSAGES.listAgreementsHeader());
                this.console.println("");
                new LicensePrinter(this.console).print(pendingLicenses);
            } else {
                this.console.println("");
                this.console.println(CliMessages.MESSAGES.noAgreementsNeeded());
            }
            Integer n = 0;
            return n;
        }
    }
}

