/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.wfchannel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.prospero.wfchannel.ResolvedArtifactsStore;

class ProsperoMavenRepositoryListener
extends AbstractRepositoryListener
implements ResolvedArtifactsStore {
    private final Map<String, MavenArtifact> manifestVersions = new HashMap<String, MavenArtifact>();

    ProsperoMavenRepositoryListener() {
    }

    @Override
    public MavenArtifact getManifestVersion(String groupId, String artifactId) {
        return this.manifestVersions.get(ProsperoMavenRepositoryListener.getKey(groupId, artifactId, "manifest", "yaml"));
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        Artifact a = event.getArtifact();
        if (a == null || a.getFile() == null) {
            return;
        }
        if (a.getClassifier() != null && a.getClassifier().equals("manifest")) {
            this.manifestVersions.put(ProsperoMavenRepositoryListener.getKey(a), new MavenArtifact(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), a.getVersion(), a.getFile()));
        }
    }

    private static String getKey(Artifact a) {
        return ProsperoMavenRepositoryListener.getKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }

    private static String getKey(String groupId, String artifactId, String classifier, String extension) {
        return String.format("%s:%s:%s:%s", groupId, artifactId, ProsperoMavenRepositoryListener.nullable(classifier), ProsperoMavenRepositoryListener.nullable(extension));
    }

    private static String nullable(String txt) {
        if (txt == null) {
            return "";
        }
        return txt;
    }
}

