/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.config.ConfigId;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.FeaturesAddAction;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.FileConflictPrinter;
import org.wildfly.prospero.cli.LicensePrinter;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractMavenCommand;
import org.wildfly.prospero.cli.commands.AbstractParentCommand;
import org.wildfly.prospero.model.FeaturePackTemplate;
import picocli.CommandLine;

@CommandLine.Command(name="feature-pack", aliases={"fp"})
public class FeaturesCommand
extends AbstractParentCommand {
    public FeaturesCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory, "feature-pack", List.of(new AddCommand(console, actionFactory)));
    }

    @CommandLine.Command(name="add", sortOptions=false)
    public static class AddCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--fpl"}, paramLabel="<feature-pack-reference>", required=true)
        private String fpl;
        @CommandLine.Option(names={"--layers"}, split=",", required=false)
        private final Set<String> layers = new HashSet<String>();
        @CommandLine.Option(names={"--target-config"})
        private Optional<String> config = Optional.empty();
        @CommandLine.Option(names={"-y", "--yes"})
        boolean skipConfirmation;
        @CommandLine.Option(names={"--accept-license-agreements"})
        boolean acceptAgreements;

        public AddCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        /*
         * Loose catch block
         */
        @Override
        public Integer call() throws Exception {
            long startTime;
            block39: {
                startTime = System.currentTimeMillis();
                if (this.fpl.split(":").length != 2) {
                    throw CliMessages.MESSAGES.featurePackNameNotMavenCoordinate();
                }
                Path installationDir = AddCommand.determineInstallationDirectory(this.directory);
                MavenOptions mavenOptions = this.parseMavenOptions();
                try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.newInstance();){
                    boolean accepted;
                    FeaturePackTemplate featurePackRecipe;
                    List repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.temporaryRepositories), (TemporaryFilesManager)temporaryFiles);
                    this.console.println(CliMessages.MESSAGES.featuresAddHeader(this.fpl, installationDir));
                    FeaturesAddAction featuresAddAction = this.actionFactory.featuresAddAction(installationDir, mavenOptions, repositories, this.console);
                    List pendingLicenses = featuresAddAction.getRequiredLicenses(this.fpl);
                    if (!pendingLicenses.isEmpty()) {
                        this.console.println(System.lineSeparator() + CliMessages.MESSAGES.featurePackRequiresLicense(this.fpl) + System.lineSeparator());
                        new LicensePrinter(this.console).print(pendingLicenses);
                        if (this.acceptAgreements) {
                            this.console.println(CliMessages.MESSAGES.agreementSkipped("--accept-license-agreements") + System.lineSeparator());
                        } else if (!this.console.confirm(CliMessages.MESSAGES.acceptAgreements() + " ", "", CliMessages.MESSAGES.installationCancelled())) {
                            Integer n = 1;
                            return n;
                        }
                    }
                    if ((featurePackRecipe = featuresAddAction.getFeaturePackRecipe(this.fpl)) != null) {
                        if (featurePackRecipe.isRequiresLayers() && this.layers.isEmpty()) {
                            this.console.error(CliMessages.MESSAGES.featurePackRequiresLayers(this.fpl), new String[0]);
                            Integer n = 2;
                            return n;
                        }
                        if (!(featurePackRecipe.isSupportsCustomization() || this.layers.isEmpty() && !this.config.isPresent())) {
                            this.console.error(CliMessages.MESSAGES.featurePackDoesNotSupportCustomization(this.fpl), new String[0]);
                            Integer n = 2;
                            return n;
                        }
                    }
                    if (!featuresAddAction.isFeaturePackAvailable(this.fpl)) {
                        this.console.error(CliMessages.MESSAGES.featurePackNotFound(this.fpl), new String[0]);
                        Integer n = 2;
                        return n;
                    }
                    if (!this.skipConfirmation) {
                        accepted = this.console.confirm(CliMessages.MESSAGES.featuresAddPrompt(), CliMessages.MESSAGES.featuresAddPromptAccepted(), CliMessages.MESSAGES.featuresAddPromptCancelled());
                    } else {
                        this.console.println(CliMessages.MESSAGES.featuresAddPromptAccepted());
                        accepted = true;
                    }
                    if (!accepted) break block39;
                    try (TemporaryFilesManager temporaryFilesManager = TemporaryFilesManager.newInstance();){
                        Path candidate = temporaryFilesManager.createTempDirectory("prospero-fp-candidate");
                        ConfigId configId = AddCommand.parseConfigName(this.config.orElse(null));
                        if (this.layers.isEmpty()) {
                            featuresAddAction.addFeaturePack(this.fpl, configId == null ? Collections.emptySet() : Set.of(configId), candidate);
                        } else {
                            featuresAddAction.addFeaturePackWithLayers(this.fpl, this.layers, configId, candidate);
                        }
                        ApplyCandidateAction applyCandidateAction = this.actionFactory.applyUpdate(installationDir, candidate);
                        if (this.confirmConflicts(applyCandidateAction.getConflicts())) {
                            applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.FEATURE_ADD);
                        }
                    }
                    catch (FeaturesAddAction.LayerNotFoundException e) {
                        if (!e.getSupportedLayers().isEmpty()) {
                            this.console.error(CliMessages.MESSAGES.layerNotSupported(this.fpl, e.getLayers(), e.getSupportedLayers()), new String[0]);
                        } else {
                            this.console.error(CliMessages.MESSAGES.layerNotSupported(this.fpl), new String[0]);
                        }
                        Integer n = 2;
                        if (temporaryFiles != null) {
                            temporaryFiles.close();
                        }
                        return n;
                    }
                    catch (FeaturesAddAction.ModelNotDefinedException e) {
                        Integer n;
                        block40: {
                            this.console.error(CliMessages.MESSAGES.modelNotSupported(this.fpl, e.getModel(), e.getSupportedModels()), new String[0]);
                            n = 2;
                            if (temporaryFiles == null) break block40;
                            temporaryFiles.close();
                        }
                        return n;
                    }
                    catch (FeaturesAddAction.ConfigurationNotFoundException e) {
                        Integer n;
                        block41: {
                            this.console.error(CliMessages.MESSAGES.galleonConfigNotSupported(this.fpl, e.getModel(), e.getName()), new String[0]);
                            n = 2;
                            if (temporaryFiles == null) break block41;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            temporaryFiles.close();
                        }
                        return n;
                    }
                }
            }
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }

        private boolean confirmConflicts(List<FileConflict> conflicts) {
            if (conflicts.isEmpty() || this.skipConfirmation) {
                this.console.println(CliMessages.MESSAGES.featuresAddPromptAccepted());
                return true;
            }
            FileConflictPrinter.print(conflicts, this.console);
            return this.skipConfirmation || this.console.confirm(CliMessages.MESSAGES.featuresAddPrompt(), CliMessages.MESSAGES.featuresAddPromptAccepted(), CliMessages.MESSAGES.featuresAddPromptCancelled());
        }

        private static ConfigId parseConfigName(String config) {
            if (config == null) {
                return null;
            }
            int i = config.indexOf("/");
            if (i < 0) {
                return new ConfigId(null, config.trim());
            }
            if (i == config.length() - 1) {
                return new ConfigId(config.substring(0, i).trim(), null);
            }
            return new ConfigId(config.substring(0, i).trim(), config.substring(i + 1).trim());
        }
    }
}

