/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.prospero.actions.InstallationHistoryAction;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.DiffPrinter;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="history", sortOptions=false)
public class HistoryCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--dir"})
    Optional<Path> directory;
    @CommandLine.Option(names={"--revision"})
    Optional<String> revision;

    public HistoryCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Path installationDirectory = HistoryCommand.determineInstallationDirectory(this.directory);
        InstallationHistoryAction historyAction = this.actionFactory.history(installationDirectory, this.console);
        if (this.revision.isEmpty()) {
            List revisions = historyAction.getRevisions();
            for (SavedState savedState : revisions) {
                this.console.println(savedState.shortDescription());
            }
        } else {
            InstallationChanges changes = historyAction.compare(new SavedState(this.revision.get()));
            if (changes.isEmpty()) {
                this.console.println(CliMessages.MESSAGES.noChangesFound());
            } else {
                DiffPrinter diffPrinter = new DiffPrinter(this.console, "  ");
                boolean needsLineBreak = false;
                if (!changes.getArtifactChanges().isEmpty()) {
                    this.console.println(CliMessages.MESSAGES.diffUpdates() + ":");
                    changes.getArtifactChanges().forEach(diffPrinter::print);
                    needsLineBreak = true;
                }
                if (!changes.getChannelChanges().isEmpty()) {
                    if (needsLineBreak) {
                        this.console.println("");
                    }
                    this.console.println(CliMessages.MESSAGES.diffConfigChanges() + ":");
                    changes.getChannelChanges().forEach(diffPrinter::print);
                    needsLineBreak = true;
                }
                if (!changes.getFeatureChanges().isEmpty()) {
                    if (needsLineBreak) {
                        this.console.println("");
                    }
                    this.console.println(CliMessages.MESSAGES.diffFeaturesChanges() + ":");
                    changes.getFeatureChanges().forEach(diffPrinter::print);
                }
            }
        }
        return 0;
    }
}

