/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.nls.TranslationBundle;

class GlobalBundleCache {
    private static final Map<Locale, Map<Class, TranslationBundle>> cachedBundles = new HashMap<Locale, Map<Class, TranslationBundle>>();

    GlobalBundleCache() {
    }

    static synchronized <T extends TranslationBundle> T lookupBundle(Locale locale, Class<T> type) {
        try {
            TranslationBundle bundle2;
            Map<Class, TranslationBundle> bundles = cachedBundles.get(locale);
            if (bundles == null) {
                bundles = new HashMap<Class, TranslationBundle>();
                cachedBundles.put(locale, bundles);
            }
            if ((bundle2 = bundles.get(type)) == null) {
                bundle2 = (TranslationBundle)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bundle2.load(locale);
                bundles.put(type, bundle2);
            }
            return (T)bundle2;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    static void clear() {
        cachedBundles.clear();
    }
}

