/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager;

import java.util.Optional;
import org.wildfly.installationmanager.Channel;

public class ChannelChange {
    private Optional<Channel> oldChannel;
    private Optional<Channel> newChannel;
    private final Status status;

    public ChannelChange(Channel oldChannel, Channel newChannel, Status status) {
        this.status = status;
        this.oldChannel = Optional.ofNullable(oldChannel);
        this.newChannel = Optional.ofNullable(newChannel);
        if (this.oldChannel.isEmpty() && this.newChannel.isEmpty()) {
            throw new IllegalArgumentException("Both channels in change cannot be null");
        }
        if (this.oldChannel.isPresent() && this.newChannel.isPresent() && !this.oldChannel.get().getName().equals(this.newChannel.get().getName())) {
            throw new IllegalArgumentException("Both channels has to have the same name");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Channel> getOldChannel() {
        return this.oldChannel;
    }

    public Optional<Channel> getNewChannel() {
        return this.newChannel;
    }

    public String getName() {
        return this.newChannel.isPresent() ? this.newChannel.get().getName() : this.oldChannel.get().getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChannelChange{");
        sb.append("oldChannel=").append(this.oldChannel);
        sb.append(", newChannel=").append(this.newChannel);
        sb.append(", status=").append((Object)this.status);
        sb.append('}');
        return sb.toString();
    }

    public static enum Status {
        ADDED,
        REMOVED,
        MODIFIED;

    }
}

