/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    protected final CliConsole console;
    protected final ActionFactory actionFactory;
    private static final Logger log = Logger.getLogger(AbstractCommand.class);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, order=100)
    boolean help;
    @CommandLine.Option(names={"-vv", "--verbose"}, order=101)
    boolean verbose;

    public AbstractCommand(CliConsole console, ActionFactory actionFactory) {
        this.console = console;
        this.actionFactory = actionFactory;
    }

    protected static Path determineInstallationDirectory(Optional<Path> directoryOption) throws ArgumentParsingException {
        Path installationDirectory = directoryOption.orElse(AbstractCommand.currentDir()).toAbsolutePath();
        AbstractCommand.verifyDirectoryContainsInstallation(installationDirectory);
        return installationDirectory;
    }

    static void verifyDirectoryContainsInstallation(Path path) throws ArgumentParsingException {
        File dotGalleonDir = path.resolve(".galleon").toFile();
        File channelsFile = path.resolve(".installation").resolve("installer-channels.yaml").toFile();
        if (!dotGalleonDir.isDirectory() || !channelsFile.isFile()) {
            if (AbstractCommand.currentDir().equals(path)) {
                throw CliMessages.MESSAGES.invalidInstallationDirMaybeUseDirOption(path);
            }
            throw CliMessages.MESSAGES.invalidInstallationDir(path);
        }
    }

    static Path currentDir() {
        return Paths.get(".", new String[0]).toAbsolutePath();
    }

    protected static void verifyTargetDirectoryIsEmpty(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                log.debug("Target is not a directory");
                throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
            }
            if (path.toFile().list().length != 0) {
                log.debug("Target folder is not empty");
                throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
            }
        }
        if (!AbstractCommand.isWritable(path)) {
            log.debug("Target is not writable");
            throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
        }
    }

    private static boolean isWritable(Path path) {
        Path absPath = path.toAbsolutePath();
        if (Files.exists(absPath, new LinkOption[0])) {
            return Files.isWritable(absPath);
        }
        if (absPath.getParent() == null) {
            return false;
        }
        return AbstractCommand.isWritable(absPath.getParent());
    }
}

