/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import picocli.CommandLine;

public abstract class AbstractMavenCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--dir"})
    Optional<Path> directory;
    @CommandLine.Option(names={"--repositories"}, split=",")
    List<String> temporaryRepositories = new ArrayList<String>();
    @CommandLine.ArgGroup(exclusive=true, headingKey="localRepoOptions.heading")
    LocalRepoOptions localRepoOptions = new LocalRepoOptions();
    @CommandLine.Option(names={"--offline"})
    Optional<Boolean> offline = Optional.empty();

    public AbstractMavenCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    protected MavenOptions parseMavenOptions() throws ArgumentParsingException {
        MavenOptions.Builder builder = this.localRepoOptions.toOptions();
        this.offline.map(builder::setOffline);
        return builder.build();
    }
}

