/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.options;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

public class LocalRepoOptions {
    @CommandLine.Option(names={"--local-cache"}, paramLabel="<path>", order=6)
    Path localMavenCache;
    @CommandLine.Option(names={"--no-resolve-local-cache"}, order=7)
    Optional<Boolean> noLocalCache = Optional.empty();

    public MavenOptions.Builder toOptions() throws ArgumentParsingException {
        MavenOptions.Builder builder = MavenOptions.builder();
        if (this.noLocalCache.isPresent()) {
            builder.setNoLocalCache(this.noLocalCache.get());
        }
        if (this.localMavenCache != null) {
            if (Files.exists(this.localMavenCache, new LinkOption[0]) && !Files.isDirectory(this.localMavenCache, new LinkOption[0])) {
                throw CliMessages.MESSAGES.repositoryIsNotDirectory(this.localMavenCache);
            }
            builder.setLocalCachePath(this.localMavenCache.toAbsolutePath());
        }
        return builder;
    }
}

