/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.config.ConfigId;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.actions.FeaturesAddAction;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractMavenCommand;
import org.wildfly.prospero.cli.commands.AbstractParentCommand;
import picocli.CommandLine;

@CommandLine.Command(name="feature-pack", aliases={"fp"})
public class FeaturesCommand
extends AbstractParentCommand {
    public FeaturesCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory, "feature-pack", List.of(new AddCommand(console, actionFactory)));
    }

    @CommandLine.Command(name="add", sortOptions=false)
    public static class AddCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--fpl"}, paramLabel="<feature-pack-reference>", required=true)
        private String fpl;
        @CommandLine.Option(names={"--layers"}, split=",", required=true)
        private Set<String> layers;
        @CommandLine.Option(names={"--target-config"})
        private String config;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean skipConfirmation;

        public AddCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            if (this.fpl.split(":").length != 2) {
                throw CliMessages.MESSAGES.featurePackNameNotMavenCoordinate();
            }
            Path installationDir = AddCommand.determineInstallationDirectory(this.directory);
            MavenOptions mavenOptions = this.parseMavenOptions();
            List<Repository> repositories = RepositoryDefinition.from(this.temporaryRepositories);
            this.console.println(CliMessages.MESSAGES.featuresAddHeader(this.fpl, installationDir));
            FeaturesAddAction featuresAddAction = this.actionFactory.featuresAddAction(installationDir, mavenOptions, repositories, this.console);
            if (!featuresAddAction.isFeaturePackAvailable(this.fpl)) {
                this.console.error(CliMessages.MESSAGES.featurePackNotFound(this.fpl), new String[0]);
                return 2;
            }
            if (!this.skipConfirmation) {
                this.console.confirm(CliMessages.MESSAGES.featuresAddPrompt(), CliMessages.MESSAGES.featuresAddPromptAccepted(), CliMessages.MESSAGES.featuresAddPromptCancelled());
            } else {
                this.console.println(CliMessages.MESSAGES.featuresAddPromptAccepted());
            }
            try {
                featuresAddAction.addFeaturePackWithLayers(this.fpl, this.layers, AddCommand.parseConfigName(this.config));
            }
            catch (FeaturesAddAction.LayerNotFoundException e) {
                if (!e.getSupportedLayers().isEmpty()) {
                    this.console.error(CliMessages.MESSAGES.layerNotSupported(this.fpl, e.getLayers(), e.getSupportedLayers()), new String[0]);
                } else {
                    this.console.error(CliMessages.MESSAGES.layerNotSupported(this.fpl), new String[0]);
                }
                return 2;
            }
            catch (FeaturesAddAction.ModelNotDefinedException e) {
                this.console.error(CliMessages.MESSAGES.modelNotSupported(this.fpl, e.getModel(), e.getSupportedModels()), new String[0]);
                return 2;
            }
            catch (FeaturesAddAction.ConfigurationNotFoundException e) {
                this.console.error(CliMessages.MESSAGES.galleonConfigNotSupported(this.fpl, e.getModel(), e.getName()), new String[0]);
                return 2;
            }
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }

        private static ConfigId parseConfigName(String config) {
            if (config == null) {
                return null;
            }
            int i = config.indexOf("/");
            if (i < 0) {
                return new ConfigId(null, config.trim());
            }
            if (i == config.length() - 1) {
                return new ConfigId(config.substring(0, i).trim(), null);
            }
            return new ConfigId(config.substring(0, i).trim(), config.substring(i + 1).trim());
        }
    }
}

