/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.cli.CliMessages;

class ArtifactResolutionAnalyzer {
    ArtifactResolutionAnalyzer() {
    }

    List<Result> analyze(ArtifactResolutionException ex) {
        if (ex.getMissingArtifacts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Result> res = new ArrayList<Result>();
        List<ArtifactResult> results = ArtifactResolutionAnalyzer.getArtifactResults(ex);
        for (ArtifactCoordinate missingArtifact : ex.getMissingArtifacts()) {
            String status = ArtifactResolutionAnalyzer.failedChecksum(ArtifactResolutionAnalyzer.getResult(missingArtifact, results)) ? CliMessages.MESSAGES.checksumFailed() : CliMessages.MESSAGES.missing();
            res.add(new Result(ArtifactUtils.printCoordinate((ArtifactCoordinate)missingArtifact), status));
        }
        return res;
    }

    private static List<ArtifactResult> getArtifactResults(ArtifactResolutionException e) {
        Object t = e;
        while (t.getCause() != null) {
            if (!((t = t.getCause()) instanceof org.eclipse.aether.resolution.ArtifactResolutionException)) continue;
            return ((org.eclipse.aether.resolution.ArtifactResolutionException)t).getResults().stream().filter(r -> !r.isResolved()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static ArtifactResult getResult(ArtifactCoordinate coord, List<ArtifactResult> results) {
        for (ArtifactResult res : results) {
            Artifact artifact = res.getRequest().getArtifact();
            if (!artifact.getGroupId().equals(coord.getGroupId()) || !artifact.getArtifactId().equals(coord.getArtifactId()) || !artifact.getVersion().equals(coord.getVersion()) || !artifact.getExtension().equals(coord.getExtension())) continue;
            return res;
        }
        return null;
    }

    private static boolean failedChecksum(ArtifactResult result) {
        if (result == null) {
            return false;
        }
        for (Exception e : result.getExceptions()) {
            if (!(e instanceof ArtifactTransferException) || !(e.getCause() instanceof ChecksumFailureException)) continue;
            return true;
        }
        return false;
    }

    static class Result {
        private final String status;
        private final String coords;

        public Result(String coords, String status) {
            this.coords = coords;
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public String getCoords() {
            return this.coords;
        }

        public String toString() {
            return "Result{status='" + this.status + "', coords='" + this.coords + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.status, result.status) && Objects.equals(this.coords, result.coords);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.coords);
        }
    }
}

