/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.ChannelChange;
import org.wildfly.prospero.api.Diff;
import org.wildfly.prospero.api.FeatureChange;
import org.wildfly.prospero.cli.CliMessages;

public class DiffPrinter {
    private final String initialTab;

    public DiffPrinter(String initialTab) {
        this.initialTab = initialTab;
    }

    public void print(Diff diff) {
        this.print(diff, this.initialTab, false);
    }

    private void print(Diff diff, String tab, boolean nested) {
        System.out.print(tab);
        if (diff.getChildren().isEmpty()) {
            if (diff.hasValues()) {
                String nameText = diff.getName().map(s -> s + ":\t\t").orElse("");
                DiffPrinter.print(diff, nested, "%s%s ==> %s%n", nameText, diff.getOldValue().orElse("[]"), diff.getNewValue().orElse("[]"));
            } else {
                String nameText = diff.getName().map(s -> s + "\t\t").orElse("");
                DiffPrinter.print(diff, nested, "%s%n", nameText);
            }
        } else {
            String nameText = diff.getName().orElse("");
            DiffPrinter.print(diff, nested, "%s: %n", nameText);
            diff.getChildren().forEach(c -> this.print((Diff)c, tab + "  ", true));
        }
    }

    private static void print(Diff diff, boolean nested, String text, String ... args) {
        text = !nested ? String.format("[%s] ", DiffPrinter.getStatus(diff)) + String.format((String)text, args) : String.format((String)text, args);
        System.out.print((String)text);
    }

    private static String getStatus(Diff diff) {
        String diffType;
        String statusText;
        Diff.Status status = diff.getStatus();
        switch (status) {
            case ADDED: {
                statusText = CliMessages.MESSAGES.changeAdded();
                break;
            }
            case REMOVED: {
                statusText = CliMessages.MESSAGES.changeRemoved();
                break;
            }
            case MODIFIED: {
                statusText = CliMessages.MESSAGES.changeUpdated();
                break;
            }
            default: {
                throw new RuntimeException("Unknown status: " + status);
            }
        }
        if (diff instanceof ArtifactChange) {
            diffType = CliMessages.MESSAGES.artifactChangeType();
        } else if (diff instanceof ChannelChange) {
            diffType = CliMessages.MESSAGES.channelChangeType();
        } else if (diff instanceof FeatureChange) {
            FeatureChange.Type subType = ((FeatureChange)diff).getType();
            switch (subType) {
                case FEATURE: {
                    diffType = CliMessages.MESSAGES.featurePackTitle();
                    break;
                }
                case CONFIG: {
                    diffType = CliMessages.MESSAGES.configurationModel();
                    break;
                }
                default: {
                    diffType = subType.name();
                    break;
                }
            }
        } else {
            diffType = null;
        }
        return String.format("%s%s", statusText, diffType != null ? " " + diffType : "");
    }
}

