/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.actions.ProvisioningAction;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.LicensePrinter;
import org.wildfly.prospero.cli.commands.AbstractInstallCommand;
import picocli.CommandLine;

@CommandLine.Command(name="print-licenses", sortOptions=false)
public class PrintLicensesCommand
extends AbstractInstallCommand {
    public PrintLicensesCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        Path tempDirectory = Files.createTempDirectory("tmp-installer", new FileAttribute[0]);
        try {
            ProvisioningDefinition provisioningDefinition = this.buildDefinition().build();
            MavenOptions mavenOptions = this.getMavenOptions();
            GalleonProvisioningConfig provisioningConfig = provisioningDefinition.toProvisioningConfig();
            List<Channel> channels = this.resolveChannels(provisioningDefinition, mavenOptions);
            ProvisioningAction provisioningAction = this.actionFactory.install(tempDirectory.toAbsolutePath(), mavenOptions, this.console);
            List pendingLicenses = provisioningAction.getPendingLicenses(provisioningConfig, channels);
            if (!pendingLicenses.isEmpty()) {
                System.out.println();
                System.out.println(CliMessages.MESSAGES.listAgreementsHeader());
                System.out.println();
                new LicensePrinter().print(pendingLicenses);
            } else {
                System.out.println();
                System.out.println(CliMessages.MESSAGES.noAgreementsNeeded());
            }
            Integer n = 0;
            return n;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirectory.toFile());
        }
    }
}

