/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            if (keyword.equals("if")) {
                foundIfSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Set<ValidationMessage> ifErrors = this.ifSchema.validate(node, rootNode, at);
        if (ifErrors.isEmpty() && this.thenSchema != null) {
            errors.addAll(this.thenSchema.validate(node, rootNode, at));
        } else if (!ifErrors.isEmpty() && this.elseSchema != null) {
            errors.addAll(this.elseSchema.validate(node, rootNode, at));
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }
}

