/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.type.builtin;

import java.util.Collection;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.type.FeatureParameterType;
import org.jboss.galleon.type.ParameterTypeConversionException;
import org.jboss.galleon.util.formatparser.FormatParser;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingFormat;

public class FormattedParameterType
implements FeatureParameterType {
    protected final ParsingFormat format;

    protected FormattedParameterType(ParsingFormat format) {
        this.format = format;
    }

    @Override
    public String getName() {
        return this.format.getName();
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Object fromString(String str) throws ParameterTypeConversionException {
        if (str == null) {
            return null;
        }
        try {
            return FormatParser.parse(this.format, str);
        }
        catch (FormatParsingException e) {
            throw new ParameterTypeConversionException("Failed to parse " + this.getName() + " parameter value", e);
        }
    }

    @Override
    public String toString(Object o) throws ParameterTypeConversionException {
        return o == null ? null : o.toString();
    }

    @Override
    public boolean isCollection() {
        return this.format.isCollection();
    }

    @Override
    public boolean isMergeable() {
        return false;
    }

    @Override
    public Object merge(Object original, Object other) throws ProvisioningException {
        return other;
    }

    @Override
    public boolean resolveCapabilityElement(CapabilityResolver capResolver, Object o) throws ProvisioningException {
        if (!this.format.isCollection()) {
            capResolver.add(o);
            return true;
        }
        Collection col = (Collection)o;
        if (col.isEmpty()) {
            if (capResolver.getSpec().isOptional()) {
                return false;
            }
            throw new ProvisioningException(Errors.capabilityMissingParameter(capResolver.getSpec(), capResolver.getElem()));
        }
        capResolver.multiply(col);
        return true;
    }
}

