/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRangeParser;

public class LocalArtifactVersionRangeResolver {
    private static final MavenArtifactVersionRangeParser versionRangeParser = new MavenArtifactVersionRangeParser();
    protected final Path repoHome;

    public LocalArtifactVersionRangeResolver(Path localRepo) {
        this.repoHome = localRepo;
    }

    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, lowestQualifier, null, null);
    }

    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = this.resolveLatestVersionDir(artifact, lowestQualifier, includeVersion, excludeVersion);
        artifact.setVersion(path.getFileName().toString());
        path = path.resolve(artifact.getArtifactFileName());
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
        }
        artifact.setPath(path);
    }

    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.resolveLatestVersionDir(artifact, lowestQualifier, null, null).getFileName().toString();
    }

    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        return this.resolveLatestVersionDir(artifact, lowestQualifier, includeVersion, excludeVersion).getFileName().toString();
    }

    protected String pathDoesNotExist(MavenArtifact artifact, Path path) throws MavenUniverseException {
        return "Failed to resolve " + artifact.getCoordsAsString() + ": " + path + " does not exist";
    }

    private Path resolveLatestVersionDir(MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        Path path;
        block16: {
            String[] groupParts;
            if (artifact.getGroupId() == null) {
                MavenErrors.missingGroupId();
            }
            if (artifact.getArtifactId() == null) {
                MavenErrors.missingArtifactId();
            }
            if (artifact.getVersionRange() == null) {
                throw new MavenUniverseException("Version range is missing for " + artifact.getCoordsAsString());
            }
            Path artifactDir = this.repoHome;
            for (String part : groupParts = artifact.getGroupId().split("\\.")) {
                artifactDir = artifactDir.resolve(part);
            }
            if (!Files.exists(artifactDir = artifactDir.resolve(artifact.getArtifactId()), new LinkOption[0])) {
                throw MavenErrors.artifactNotFound(artifact, this.repoHome);
            }
            final MavenArtifactVersionRange range = versionRangeParser.parseRange(artifact.getVersionRange());
            if (lowestQualifier == null) {
                lowestQualifier = "";
            }
            final DirectoryStream<Path> stream = Files.newDirectoryStream(artifactDir);
            try {
                Iterable<String> versions = new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return new Iterator<String>(){
                            final Iterator<Path> i;
                            Path nextPath;
                            {
                                this.i = stream.iterator();
                                this.nextPath = this.toNext(range);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.nextPath != null;
                            }

                            @Override
                            public String next() {
                                if (this.nextPath != null) {
                                    String s = this.nextPath.getFileName().toString();
                                    this.nextPath = this.toNext(range);
                                    return s;
                                }
                                throw new NoSuchElementException();
                            }

                            private Path toNext(MavenArtifactVersionRange range) {
                                while (this.i.hasNext()) {
                                    MavenArtifactVersion next;
                                    Path path = this.i.next();
                                    if (!Files.isDirectory(path, new LinkOption[0]) || !range.includesVersion(next = new MavenArtifactVersion(path.getFileName().toString()))) continue;
                                    return path;
                                }
                                return null;
                            }
                        };
                    }
                };
                MavenArtifactVersion latest = MavenArtifactVersion.getLatest(versions, lowestQualifier, includeVersion, excludeVersion);
                if (latest == null) {
                    throw new MavenLatestVersionNotAvailableException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()));
                }
                path = artifactDir.resolve(latest.toString());
                if (stream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MavenUniverseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MavenUniverseException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()), e);
                }
            }
            stream.close();
        }
        return path;
    }
}

