/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.extras.bundle.create;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.logging.Logger;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.extras.converters.RepositoriesConverter;
import org.wildfly.prospero.promotion.ArtifactBundle;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import picocli.CommandLine;

@CommandLine.Command(name="create-bundle")
public class CreateBundleCommand
implements Callable<Integer> {
    private static final Logger LOG = Logger.getLogger(CreateBundleCommand.class);
    @CommandLine.Option(names={"--out"}, required=true)
    private Path bundlePath;
    @CommandLine.Option(names={"--artifact", "--artifacts"}, required=true)
    private List<String> artifacts = new ArrayList<String>();
    @CommandLine.Option(names={"--repository", "--repositories"}, converter={RepositoriesConverter.class})
    private List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();

    @Override
    public Integer call() throws Exception {
        LOG.info("Building artifact requests");
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        for (String artifactSpec : this.artifacts) {
            String[] gav = artifactSpec.split(":");
            if (gav.length < 3) {
                LOG.error("The artifact GAV is expected to contain at least 3 elements");
                return -2;
            }
            String version = gav[2];
            String classifier = null;
            String extension = "jar";
            if (gav.length == 4) {
                version = gav[3];
                classifier = gav[2];
            }
            if (gav.length == 5) {
                version = gav[4];
                classifier = gav[2];
                extension = gav[3];
            }
            DefaultArtifact artifact = new DefaultArtifact(gav[0], gav[1], classifier, extension, version, null);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.repositories, null);
            LOG.infof("{groupId: %s, artifactId: %s, classifier: %s, extension %s, version: %s}", artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
            requests.add(artifactRequest);
        }
        LOG.info("Downloading artifacts");
        MavenSessionManager mavenSessionManager = new MavenSessionManager(MavenOptions.DEFAULT_OPTIONS);
        RepositorySystem system = mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = mavenSessionManager.newRepositorySystemSession(system, true);
        try {
            List<ArtifactResult> artifactResults = system.resolveArtifacts(session, requests);
            List downloadedArtifacts = artifactResults.stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
            LOG.info("Creating bundle");
            ArtifactBundle.createCustomizationArchive(downloadedArtifacts, this.bundlePath.toFile());
            return 0;
        }
        catch (ArtifactResolutionException e) {
            LOG.warn("Unable to find following artifacts:");
            e.getResults().stream().filter(r -> !r.isResolved()).map(ArtifactResult::getRequest).forEach(r -> LOG.warn(" * " + r.getArtifact()));
            return -1;
        }
    }
}

